<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Character separators
    |--------------------------------------------------------------------------
    |
    | An array of special characters that could be used a separators.
    |
    |
    */
    'separators' => [
        '@',
        '#',
        '%',
        '&',
        '_',
        ';',
        "'",
        '"',
        ',',
        '~',
        '`',
        '|',
        '!',
        '$',
        '^',
        '*',
        '(',
        ')',
        '-',
        '+',
        '=',
        '{',
        '}',
        '[',
        ']',
        ':',
        '<',
        '>',
        '?',
        '.',
        '/',
    ],

    /*
    |--------------------------------------------------------------------------
    | Character Substitutions
    |--------------------------------------------------------------------------
    |
    | An array of alpha characters and their possible substitutions.
    |
    |
    */
    'substitutions' => [
        '/a/' => ['a', '4', '@', 'Á', 'á', 'À', 'Â', 'à', 'Â', 'â', 'Ä', 'ä', 'Ã', 'ã', 'Å', 'å', 'æ', 'Æ', 'α', 'Δ', 'Λ', 'λ'],
        '/b/' => ['b', '8', '\\', '3', 'ß', 'Β', 'β'],
        '/c/' => ['c', 'Ç', 'ç', 'ć', 'Ć', 'č', 'Č', '¢', '€', '<', '(', '{', '©'],
        '/d/' => ['d', '\\', ')', 'Þ', 'þ', 'Ð', 'ð'],
        '/e/' => ['e', '3', '€', 'È', 'è', 'É', 'é', 'Ê', 'ê', 'ë', 'Ë', 'ē', 'Ē', 'ė', 'Ė', 'ę', 'Ę', '∑'],
        '/f/' => ['f', 'ƒ'],
        '/g/' => ['g', '6', '9'],
        '/h/' => ['h', 'Η'],
        '/i/' => ['i', '!', '|', ']', '[', '1', '∫', 'Ì', 'Í', 'Î', 'Ï', 'ì', 'í', 'î', 'ï', 'ī', 'Ī', 'į', 'Į'],
        '/j/' => ['j'],
        '/k/' => ['k', 'Κ', 'κ'],
        '/l/' => ['l', '!', '|', ']', '[', '£', '∫', 'Ì', 'Í', 'Î', 'Ï', 'ł', 'Ł'],
        '/m/' => ['m'],
        '/n/' => ['n', 'η', 'Ν', 'Π', 'ñ', 'Ñ', 'ń', 'Ń'],
        '/o/' => ['o', '0', 'Ο', 'ο', 'Φ', '¤', '°', 'ø', 'ô', 'Ô', 'ö', 'Ö', 'ò', 'Ò', 'ó', 'Ó', 'œ', 'Œ', 'ø', 'Ø', 'ō', 'Ō', 'õ', 'Õ'],
        '/p/' => ['p', 'ρ', 'Ρ', '¶', 'þ'],
        '/q/' => ['q'],
        '/r/' => ['r', '®'],
        '/s/' => ['s', '5', '\$', '§', 'ß', 'Ś', 'ś', 'Š', 'š'],
        '/t/' => ['t', 'Τ', 'τ'],
        '/u/' => ['u', 'υ', 'µ', 'û', 'ü', 'ù', 'ú', 'ū', 'Û', 'Ü', 'Ù', 'Ú', 'Ū'],
        '/v/' => ['v', 'υ', 'ν'],
        '/w/' => ['w', 'ω', 'ψ', 'Ψ'],
        '/x/' => ['x', 'Χ', 'χ'],
        '/y/' => ['y', '¥', 'γ', 'ÿ', 'ý', 'Ÿ', 'Ý'],
        '/z/' => ['z', 'Ζ', 'ž', 'Ž', 'ź', 'Ź', 'ż', 'Ż'],
    ],

    /*
    |--------------------------------------------------------------------------
    | Cache Configuration
    |--------------------------------------------------------------------------
    |
    | Specify the cache driver to use for storing profanity expressions.
    | If not specified, the default Laravel cache driver will be used.
    |
    */
    'cache_driver' => env('BLASP_CACHE_DRIVER', null),

    /*
    |--------------------------------------------------------------------------
    | False Positives
    |--------------------------------------------------------------------------
    |
    | An array of false positives
    |
    |
    */
    'false_positives' => [
        'hello',
        'scunthorpe',
        'cockburn',
        'penistone',
        'lightwater',
        'assume',
        'bass',
        'class',
        'compass',
        'pass',
        'dickinson',
        'middlesex',
        'cockerel',
        'butterscotch',
        'blackcock',
        'countryside',
        'arsenal',
        'flick',
        'flicker',
        'analyst',
        'cocktail',
        'musicals hit',
        'is hit',
        'blackcocktail',
        'its not',
    ],


    /*
    |--------------------------------------------------------------------------
    | Profanities
    |--------------------------------------------------------------------------
    |
    | An array of profanities
    |
    |
    */
    'profanities' => [
        'abbo',
        'abortionist',
        'abuser',
        'ahole',
        'alabama hotpocket',
        'alligatorbait',
        'anal',
        'analannie',
        'analsex',
        'areola',
        'arse',
        'arsebagger',
        'arsebandit',
        'arseblaster',
        'arsecowboy',
        'arsefuck',
        'arsefucker',
        'arsehat',
        'arsehole',
        'arseholes',
        'arsehore',
        'arsejockey',
        'arsekiss',
        'arsekisser',
        'arselick',
        'arselicker',
        'arselover',
        'arseman',
        'arsemonkey',
        'arsemunch',
        'arsemuncher',
        'arsepacker',
        'arsepirate',
        'arsepuppies',
        'arseranger',
        'arses',
        'arsewhore',
        'arsewipe',
        'ass',
        'assbag',
        'assbagger',
        'assbandit',
        'assbanger',
        'assbite',
        'assblaster',
        'assclown',
        'asscock',
        'asscowboy',
        'asscracker',
        'asses',
        'assface',
        'assfuck',
        'assfucker',
        'assgoblin',
        'ass-hat',
        'asshat',
        'asshead',
        'asshole',
        'assholes',
        'assholz',
        'asshopper',
        'asshore',
        'ass-jabber',
        'assjacker',
        'assjockey',
        'asskiss',
        'asskisser',
        'assklown',
        'asslick',
        'asslicker',
        'asslover',
        'assman',
        'assmonkey',
        'ass monkey',
        'assmunch',
        'assmuncher',
        'assnigger',
        'asspacker',
        'ass-pirate',
        'asspirate',
        'asspuppies',
        'assranger',
        'assshit',
        'assshole',
        'asssucker',
        'asswad',
        'asswhore',
        'asswipe',
        'axwound',
        'azzhole',
        'backdoorman',
        'badfuck',
        'baldy',
        'ball licker',
        'balllicker',
        'ballsack',
        'bampot',
        'banging',
        'barelylegal',
        'barface',
        'barfface',
        'bassterds',
        'bastard',
        'bastards',
        'bastardz',
        'basterds',
        'basterdz',
        'bazongas',
        'bazooms',
        'beaner',
        'beastality',
        'beastial',
        'beastiality',
        'beat-off',
        'beatoff',
        'beatyourmeat',
        'bestial',
        'bestiality',
        'biatch',
        'bicurious',
        'bigass',
        'bigbastard',
        'bigbutt',
        'bitch',
        'bitchass',
        'bitcher',
        'bitches',
        'bitchez',
        'bitchin',
        'bitching',
        'bitchslap',
        'bitchtits',
        'bitchy',
        'biteme',
        'blow job',
        'blowjob',
        'boffing',
        'bohunk',
        'bollick',
        'bollock',
        'bollocks',
        'bollox',
        'bondage',
        'boner',
        'boob',
        'boobies',
        'boobs',
        'booby',
        'bootycall',
        'bountybar',
        'breastjob',
        'breastlover',
        'breastman',
        'brothel',
        'brotherfucker',
        'bugger',
        'buggered',
        'buggery',
        'bukake',
        'bullcrap',
        'bulldike',
        'bulldyke',
        'bullshit',
        'bumblefuck',
        'bumfuck',
        'bungabunga',
        'bunghole',
        'butchbabes',
        'butchdike',
        'butchdyke',
        'butt-bang',
        'buttbang',
        'buttcheeks',
        'buttface',
        'butt-fuck',
        'buttfuck',
        'buttfucka',
        'butt-fucker',
        'buttfucker',
        'butt-fuckers',
        'buttfuckers',
        'butthead',
        'butthole',
        'buttman',
        'buttmunch',
        'buttmuncher',
        'butt-pirate',
        'buttpirate',
        'butt plug',
        'buttplug',
        'buttstain',
        'buttwipe',
        'byatch',
        'cacker',
        'cameljockey',
        'camel toe',
        'cameltoe',
        'carpet muncher',
        'carpetmuncher',
        'cawk',
        'cawks',
        'chav',
        'cherrypopper',
        'chesticle',
        'chickslick',
        'chinc',
        'chink',
        'choad',
        'chode',
        'clamdigger',
        'clamdiver',
        'clit',
        'clitface',
        'clitfuck',
        'clitoris',
        'clogwog',
        'clunge',
        'clusterfuck',
        'cnts',
        'cntz',
        'cock',
        'cockass',
        'cockbite',
        'cockblock',
        'cockblocker',
        'cockburger',
        'cockcowboy',
        'cockface',
        'cockfight',
        'cockfucker',
        'cock-head',
        'cockhead',
        'cockjockey',
        'cockknob',
        'cockknoker',
        'cocklicker',
        'cocklover',
        'cockmaster',
        'cockmongler',
        'cockmongruel',
        'cockmonkey',
        'cockmuncher',
        'cocknob',
        'cocknose',
        'cocknugget',
        'cockqueen',
        'cockrider',
        'cocks',
        'cockshit',
        'cocksman',
        'cocksmith',
        'cocksmoke',
        'cocksmoker',
        'cocksniffer',
        'cocksucer',
        'cocksuck',
        'cocksucked',
        'cock-sucker',
        'cocksucker',
        'cocksucking',
        'cocktease',
        'cockwaffle',
        'cocky',
        'coitus',
        'cok',
        'commie',
        'coochie',
        'coochy',
        'coon',
        'coondog',
        'cooter',
        'copulate',
        'cracker',
        'crackpipe',
        'crack-whore',
        'crackwhore',
        'crap',
        'crappy',
        'crotchjockey',
        'crotchmonkey',
        'crotchrot',
        'cuck',
        'cum',
        'cumbubble',
        'cumdumpster',
        'cumfest',
        'cumguzzler',
        'cumjockey',
        'cumm',
        'cumquat',
        'cumqueen',
        'cumshot',
        'cumslut',
        'cumtart',
        'cunilingus',
        'cunillingus',
        'cunnie',
        'cunnilingus',
        'cunntt',
        'cunt',
        'cuntass',
        'cunteyed',
        'cuntface',
        'cuntfucker',
        'cunthole',
        'cuntlick',
        'cuntlicker',
        'cuntlicker',
        'cuntlicking',
        'cuntrag',
        'cunts',
        'cuntslut',
        'cuntsucker',
        'cuntz',
        'cybersex',
        'cyberslimer',
        'dago',
        'dammit',
        'damn',
        'damnation',
        'damnit',
        'darkie',
        'darky',
        'datnigga',
        'deapthroat',
        'deepthroat',
        'deggo',
        'dego',
        'devilworshipper',
        'dick',
        'dickbag',
        'dickbeaters',
        'dickbrain',
        'dickface',
        'dickforbrains',
        'dickfuck',
        'dickfucker',
        'dickhead',
        'dickhole',
        'dickjuice',
        'dickless',
        'dicklick',
        'dicklicker',
        'dickmilk',
        'dickmonger',
        'dicks',
        'dickslap',
        'dick-sneeze',
        'dicksucker',
        'dicksucking',
        'dicktickler',
        'dickwad',
        'dickweasel',
        'dickweed',
        'dickwod',
        'dike',
        'dildo',
        'dildos',
        'dilldo',
        'dilldos',
        'dipshit',
        'dipstick',
        'dixiedike',
        'dixiedyke',
        'doggiestyle',
        'doggystyle',
        'dominatricks',
        'dominatrics',
        'dominatrix',
        'doochbag',
        'dookie',
        'douch',
        'douchbag',
        'douche',
        'douchebag',
        'douche-fag',
        'douchewaffle',
        'drag queen',
        'dragqueen',
        'dragqween',
        'dripdick',
        'dumass',
        'dumb ass',
        'dumbass',
        'dumbbitch',
        'dumbfuck',
        'dumbshit',
        'dumshit',
        'dyke',
        'easyslut',
        'eatballs',
        'eatme',
        'eatpussy',
        'ejaculate',
        'ejaculated',
        'ejaculating',
        'ejaculation',
        'enema',
        'excrement',
        'facefucker',
        'facist',
        'faeces',
        'fag',
        'fagbag',
        'faget',
        'fagfucker',
        'fagging',
        'faggit',
        'faggot',
        'faggotcock',
        'faggots',
        'fagit',
        'fagot',
        'fags',
        'fagtard',
        'fagz',
        'faig',
        'faigs',
        'fannyfucker',
        'fark',
        'farted',
        'farting',
        'farty',
        'fastfuck',
        'fatass',
        'fatfuck',
        'fatfucker',
        'fatso',
        'feces',
        'felatio',
        'felch',
        'felcher',
        'felching',
        'fellatio',
        'feltch',
        'feltcher',
        'feltching',
        'fingerfuck',
        'fingerfucked',
        'fingerfucker',
        'fingerfuckers',
        'fingerfucking',
        'fister',
        'fistfuck',
        'fistfucked',
        'fistfucker',
        'fistfucking',
        'fisting',
        'flamer',
        'flasher',
        'flid',
        'flipping the bird',
        'flyd',
        'flydie',
        'flydye',
        'fondle',
        'footaction',
        'footfuck',
        'footfucker',
        'footlicker',
        'fornicate',
        'freakfuck',
        'freakyfucker',
        'freefuck',
        'fubar',
        'fucck',
        'fuck',
        'fucka',
        'fuckable',
        'fuckass',
        'fuckbag',
        'fuckboy',
        'fuckbrain',
        'fuckbuddy',
        'fuckbutt',
        'fuckbutter',
        'fucked',
        'fucker',
        'fuckers',
        'fuckersucker',
        'fuckface',
        'fuckfest',
        'fuckfreak',
        'fuckfriend',
        'fuckhead',
        'fuckher',
        'fuckhole',
        'fuckin',
        'fuckina',
        'fucking',
        'fuckingbitch',
        'fuckinnuts',
        'fuckinright',
        'fuckit',
        'fuckknob',
        'fuckme',
        'fuckmehard',
        'fuckmonkey',
        'fucknut',
        'fucknutt',
        'fuckoff',
        'fuckpig',

        'fuckstick',
        'fucktard',
        'fucktart',
        'fuckup',
        'fuckwad',
        'fuckwhore',
        'fuckwit',
        'fuckwitt',
        'fuckyou',
        'fudge packer',
        'fudgepacker',
        'Fudge Packer',
        'fugly',
        'fuk',
        'Fukah',
        'Fuken',
        'fuker',
        'Fukin',
        'Fukk',
        'Fukkah',
        'Fukken',
        'Fukker',
        'Fukkin',
        'fuks',
        'funfuck',
        'fuuck',
        'gang bang',
        'gangbang',
        'gangbanged',
        'gangbanger',
        'gatorbait',
        'gayass',
        'gaybob',
        'gayboy',
        'gaydo',
        'gayfuck',
        'gayfuckist',
        'gaygirl',
        'gaylord',
        'gaymuthafuckinwhore',
        'gays',
        'gaysex',
        'gaytard',
        'gaywad',
        'gayz',
        'getiton',
        'givehead',
        'glazeddonut',
        'godammit',
        'goddamit',
        'goddammit',
        'goddamn',
        'goddamned',
        'god-damned',
        'goddamnes',
        'goddamnit',
        'goddamnmuthafucker',
        'goldenshower',
        'gonorrehea',
        'gonzagas',
        'gooch',
        'gook',
        'gotohell',
        'greaseball',
        'gringo',
        'grostulation',
        'guido',
        'gypo',
        'gypp',
        'gyppie',
        'gyppo',
        'gyppy',
        'handjob',
        'hard on',
        'hardon',
        'headfuck',
        'heeb',
        'hell',
        'herpes',
        'hijacker',
        'hijacking',
        'hillbillies',
        'hindoo',
        'hitler',
        'hitlerism',
        'hitlerist',
        'hoar',
        'hobo',
        'hoe',
        'hoes',
        'holestuffer',
        'homo',
        'homobangers',
        'homodumbshit',
        'honger',
        'honkers',
        'honkey',
        'honky',
        'hookers',
        'hoor',
        'hoore',
        'hore',
        'horney',
        'horniest',
        'horny',
        'horseshit',
        'hosejob',
        'hotdamn',
        'hotpussy',
        'hottotrot',
        'humping',
        'hymen',
        'iblowu',
        'idiot',
        'incest',
        'insest',
        'internet wife',
        'inthebuff',
        'jackass',
        'jackoff',
        'jackshit',
        'jagoff',
        'jap',
        'japcrap',
        'japs',
        'jerkass',
        'jerk off',
        'jerk-off',
        'jerkoff',
        'jesuschrist',
        'jigaboo',
        'jiggabo',
        'jihad',
        'jijjiboo',
        'jisim',
        'jism',
        'jiss',
        'jizim',
        'jizjuice',
        'jizm',
        'jizm',
        'jizz',
        'jizzim',
        'jizzum',
        'jubblies',
        'juggalo',
        'jungle bunny',
        'junglebunny',
        'kiddy fiddler',
        'kike',
        'kinky',
        'kissass',
        'knobz',
        'kondum',
        'kooch',
        'kootch',
        'krap',
        'krappy',
        'kraut',
        'kumbubble',
        'kumbullbe',
        'kummer',
        'kumming',
        'kums',
        'kunilingus',
        'kunnilingus',
        'kunt',
        'kunts',
        'kuntz',
        'kyke',
        'labia',
        'lactate',
        'lady boy',
        'ladyboy',
        'lameass',
        'lapdance',
        'lardass',
        'lesbain',
        'lesbayn',
        'lesbian',
        'lesbin',
        'lesbo',
        'lezbe',
        'lezbefriends',
        'lezbo',
        'lezz',
        'lezzer',
        'lezzie',
        'lezzo',
        'libido',
        'lickme',
        'limpdick',
        'lipshits',
        'lipshitz',
        'livesex',
        'lmfao',
        'loadedgun',
        'lovebone',
        'lovegoo',
        'lovegun',
        'lovejuice',
        'lovemuscle',
        'lovepistol',
        'loverocket',
        'low life',
        'lowlife',
        'lubejob',
        'luckycameltoe',
        'manhater',
        'manpaste',
        'masochist',
        'masokist',
        'massterbait',
        'masstrbait',
        'masstrbate',
        'mastabate',
        'mastabater',
        'masterbaiter',
        'masterbate',
        'master bates',
        'masterbates',
        'mastrabator',
        'masturbate',
        'masturbating',
        'mattressprincess',
        'mcfagget',
        'meatbeater',
        'meatrack',
        'mgger',
        'mggor',
        'milf',
        'minge',
        'mofo',
        'molest',
        'molestation',
        'molester',
        'molestor',
        'moneyshot',
        'mooncricket',
        'moron',
        'mothafuck',
        'mothafucka',
        'mothafuckaz',
        'mothafucked',
        'mothafucker',
        'motha fucker',
        'mothafuckin',
        'mothafucking',
        'mothafuckings',
        'motha fuker',
        'motha fukkah',
        'motha fukker',
        'motherfuck',
        'motherfucked',
        'mother-fucker',
        'motherfucker',
        'mother fucker',
        'motherfuckin',
        'motherfucking',
        'motherfuckings',
        'mother fukah',
        'mother fuker',
        'mother fukkah',
        'mother fukker',
        'motherlovebone',
        'muff',
        'muffdive',
        'muffdiver',
        'muffindiver',
        'mufflikcer',
        'muncher',
        'munging',
        'muthafucker',
        'mutha fucker',
        'mutha fukah',
        'mutha fuker',
        'mutha fukkah',
        'mutha fukker',
        'nastt',
        'nastybitch',
        'nastyho',
        'nastyslut',
        'nastywhore',
        'nazi',
        'necro',
        'negro',
        'negroes',
        'negroid',
        'nigaboo',
        'nigga',
        'niggah',
        'niggaracci',
        'niggard',
        'niggarded',
        'niggarding',
        'niggardliness',
        "niggardliness's",
        'niggardly',
        "niggard's",
        'niggards',
        'niggaz',
        'nigger',
        'niggerhead',
        'niggerhole',
        "nigger's",
        'niggers',
        'niggle',
        'niggled',
        'niggles',
        'niggling',
        'nigglings',
        'niggor',
        'niggur',
        'niglet',
        'nignog',
        'nigr',
        'nigra',
        'nigre',
        'nigur',
        'niiger',
        'niigr',
        'nipple',
        'nipplering',
        'nittit',
        'nlgger',
        'nlggor',
        'nofuckingway',
        'nonce',
        'nookey',
        'nookie',
        'nudger',
        'nut case',
        'nutcase',
        'nutfucker',
        'nut sack',
        'nutsack',
        'ontherag',
        'orafis',
        'orgasim',
        'orgasm',
        'orgasum',
        'orgies',
        'orgy',
        'oriface',
        'orifice',
        'orifiss',
        'osama bin laden',
        'packi',
        'packie',
        'packy',
        'paedo',
        'paedofile',
        'paedophile',
        'paki',
        'pakie',
        'paky',
        'palesimian',
        'panooch',
        'panti',
        'pearlnecklace',
        'pecker',
        'peckerhead',
        'peckerwood',
        'peedo',
        'peeenus',
        'peeenusss',
        'peehole',
        'peenus',
        'peinus',
        'penas',
        'penile',
        'penisbanger',
        'penis-breath',
        'penises',
        'penisfucker',
        'penispuffer',
        'penus',
        'penuus',
        'perv',
        'perversion',
        'pervert',
        'phonesex',
        'phuc',
        'phuck',
        'phuk',
        'phuked',
        'phuker',
        'phuking',
        'phukked',
        'phukker',
        'phukking',
        'phungky',
        'phuq',
        'pi55',
        'picaninny',
        'piccaninny',
        'pickaninny',
        'pikey',
        'piky',
        'pimper',
        'pimpjuic',
        'pimpjuice',
        'pimpsimp',
        'pindick',
        'piss',
        'pissed',
        'pissed off',
        'pisser',
        'pisses',
        'pissflaps',
        'pisshead',
        'pissin',
        'pissing',
        'pissoff',
        'play boy',
        'playboy',
        'play bunny',
        'playbunny',
        'play girl',
        'playgirl',
        'plumper',
        'pocketpool',
        'polac',
        'polack',
        'polak',
        'polesmoker',
        'pollock',
        'poon',
        'poonani',
        'poonany',
        'poontang',
        'pooperscooper',
        'pooping',
        'poorwhitetrash',
        'poostabber',
        'popimp',
        'porch monkey',
        'porchmonkey',
        'porn',
        'pornflick',
        'pornking',
        'porno',
        'pornprincess',
        'pric',
        'prick',
        'prik',
        'prickhead',
        'prostitute',
        'pu55i',
        'pu55y',
        'pube',
        'pubiclice',
        'puke',
        'punanny',
        'punta',
        'puntang',
        'purinaprincess',
        'pusse',
        'pussee',
        'pussie',
        'pussies',
        'pussy',
        'pussyeater',
        'pussyfucker',
        'pussylicker',
        'pussylicking',
        'pussylips',
        'pussylover',
        'pussypounder',
        'pusy',
        'puto',
        'puuke',
        'puuker',
        'queef',
        'queer',
        'queerbait',
        'queerhole',
        'queers',
        'queerz',
        'quim',
        'qweers',
        'qweerz',
        'qweir',
        'rag head',
        'raghead',
        'raped',
        'rapist',
        'rearend',
        'rearentry',
        'recktum',
        'rectum',
        'redneck',
        'renob',
        'rentafuck',
        'rimjob',
        'rimming',
        'ruski',
        'russki',
        'russkie',
        'sadist',
        'sadom',
        'saeema butt',
        'sandm',
        'sand nigger',
        'sandnigger',
        'scag',
        'scank',
        'scat',
        'schlong',
        'screwing',
        'screwyou',
        'scrote',
        'scrotum',
        'scum',
        'scumbag',
        'seaman staines',
        'semen',
        'sexed',
        'sexfarm',
        'sexhound',
        'sexhouse',
        'sexing',
        'sexkitten',
        'sexpot',
        'sexslave',
        'sextogo',
        'sextoy',
        'sextoys',
        'sexwhore',
        'sexymoma',
        'sexy-slim',
        'seymour butts',
        'shag',
        'shagger',
        'shaggin',
        'shagging',
        'shat',
        'shhit',
        'shit',
        'shitass',
        'shitbag',
        'shitbagger',
        'shitbrains',
        'shitbreath',
        'shitcan',
        'shitcanned',
        'shitcunt',
        'shitdick',
        'shite',
        'shiteater',
        'shited',
        'shiter',
        'shitface',
        'shitfaced',
        'shitfit',
        'shitforbrains',
        'shitfuck',
        'shitfucker',
        'shitfull',
        'shithapens',
        'shithappens',
        'shithead',
        'shithole',
        'shithouse',
        'shiting',
        'shitlist',
        'shitola',
        'shitoutofluck',
        'shits',
        'shitspitter',
        'shitstain',
        'shitted',
        'shitter',
        'shittiest',
        'shitting',
        'shitty',
        'shity',
        'shitz',
        'shiz',
        'shiznit',
        'shortfuck',
        'shyt',
        'shyte',
        'shytty',
        'shyty',
        'sissy',
        'sixsixsix',
        'sixtynine',
        'sixtyniner',
        'skanck',
        'skank',
        'skankbitch',
        'skankee',
        'skankey',
        'skankfuck',
        'skanks',
        'skankwhore',
        'skanky',
        'skankybitch',
        'skankywhore',
        'skeet',
        'skinflute',
        'skullfuck',
        'skum',
        'skumbag',
        'slanteye',
        'slantyeye',
        'slapper',
        'slavedriver',
        'sleezebag',
        'sleezeball',
        'slideitin',
        'slimeball',
        'slimebucket',
        'slopehead',
        'slopey',
        'slopy',
        'slut',
        'slutbag',
        'sluts',
        'slutt',
        'slutting',
        'slutty',
        'slutwear',
        'slutwhore',
        'slutz',
        'smackthemonkey',
        'smeg',
        'smelly',
        'smut',
        'snatch',
        'snatchpatch',
        'snot',
        'snowback',
        'snownigger',
        'sodom',
        'sodomise',
        'sodomite',
        'sodomize',
        'sodomy',
        'son-of-a-bitch',
        'sonofabitch',
        'sonofbitch',
        'spac',
        'spacca',
        'spaghettibender',
        'spaghettinigger',
        'spankthemonkey',
        'spazza',
        'sperm',
        'spermacide',
        'spermbag',
        'spermhearder',
        'spermherder',
        'spic',
        'spick',
        'spig',
        'spigotty',
        'spik',
        'spitter',
        'splittail',
        'splooge',
        'spooge',
        'spook',
        'spreadeagle',
        'squaw',
        'stabber',
        'stiffy',
        'strapon',
        'stripclub',
        'stroking',
        'stupidfuck',
        'stupidfucker',
        'suckass',
        'suckdick',
        'sucker',
        'suckme',
        'suckmyass',
        'suckmydick',
        'suckmytit',
        'suckoff',
        'swastika',
        'tampon',
        'tarbaby',
        'tard',
        'teat',
        'teste',
        'testicle',
        'testicles',
        'thicklips',
        'thicko',
        'thirdeye',
        'thirdleg',
        'threesome',
        'thundercunt',
        'timbernigger',
        'tit',
        'titbitnipply',
        'titfuck',
        'titfucker',
        'titfuckin',
        'titjob',
        'titlicker',
        'titlover',
        'tits',
        'tittie',
        'titties',
        'titty',
        'tittyfuck',
        'tonguethrust',
        'tonguethruster',
        'tonguetramp',
        'torture',
        'tosser',
        'tosspot',
        'towel head',
        'towelhead',
        'trailertrash',
        'tramp',
        'trannie',
        'tranny',
        'trots',
        'trouser snake',
        'tuckahoe',
        'tunneloflove',
        'turd',
        'twat',
        'twatlips',
        'twats',
        'twatwaffle',
        'twink',
        'twinkie',
        'twobitwhore',
        'unclefucker',
        'unfuckable',
        'upskirt',
        'uptheass',
        'upthebutt',
        'urinate',
        'urine',
        'usama bin laden',
        'uterus',
        'vag',
        'vagina',
        'vaginal',
        'vajayjay',
        'vajina',
        'va-j-j',
        'valjina',
        'vibrater',
        'vibrator',
        'vietcong',
        'violate',
        'violation',
        'virginbreaker',
        'vjayjay',
        'vomit',
        'vullva',
        'vulva',
        'wank',
        'wanker',
        'wanking',
        'wankjob',
        'waysted',
        'welcher',
        'wetback',
        'wetspot',
        'whacker',
        'whigger',
        'whiskeydick',
        'whiskydick',
        'whitenigger',
        'whitetrash',
        'whitey',
        'whoor',
        'whop',
        'whore',
        'whorebag',
        'whoreface',
        'whorefucker',
        'whorehouse',
        'wife beater',
        'williewanker',
        'wog',
        'wop',
        'wuss',
        'wuzzie',
        'x-rated',
        'xrated',
        'yellowman',
        'zigabo',
        'zipperhea',
        'zipper head',
    ],
];
