<?php

/*
Plugin Name: Ampology - Avada Yoast Sitemap Cleanup
Description: Removes XML Sitemaps related to the internal functions of Avada, thus preventing Google attempting to crawl things that are only applicable internally.
Version: 1.0
Author: Ampology
Author URI: https://ampology.co.uk
*/

if (!defined('ABSPATH')) {
    exit;
}

/* Exclude Multiple Content Types From Yoast SEO Sitemap */
add_filter( 'wpseo_sitemap_exclude_post_type', 'sitemap_exclude_post_type', 10, 2 );

function sitemap_exclude_post_type( $value, $post_type ) 
{
    $post_type_to_exclude = array();
    if( in_array( $post_type, $post_type_to_exclude ) ) 

    return true;
}

/* Exclude Multiple Taxonomies From Yoast SEO Sitemap */
add_filter( 'wpseo_sitemap_exclude_taxonomy', 'sitemap_exclude_taxonomy', 10, 2 );

function sitemap_exclude_taxonomy( $value, $taxonomy ) 
{

    $taxonomy_to_exclude = array('post_tag','element_category', 'fusion_tb_category');

    if( in_array( $taxonomy, $taxonomy_to_exclude ) ) return true;

}