<?php
/*
Plugin Name: Ampology User Picture
Description: Displays the ampology_team_picture field for post authors via a shortcode.
Version: 1.0
Author: Anthony Shapley
*/

function ampology_get_user_pic() {
    global $post;
    
    // Get the post author's ID
    $author_id = $post->post_author;

    // Get the ACF image field (assumed to be an attachment ID)
    $image_id = get_user_meta($author_id, 'ampology_team_picture', true);

    // If it's empty, return a default message
    if (empty($image_id)) {
        return 'No picture available.';
    }

    // Get the image URL using wp_get_attachment_image_src() for a specific size (e.g., 'medium')
    $image_data = wp_get_attachment_image_src($image_id, 'medium'); // you can change 'medium' to another size if needed

    // If there's an error getting the image URL, return a default message
    if (!$image_data) {
        return null;
    }

    $image_url = $image_data[0];
    
    return $image_url;
}
add_shortcode('ampology_user_pic', 'ampology_get_user_pic');

register_activation_hook(__FILE__, 'ampology_user_pic_activate');
function ampology_user_pic_activate() {
    // Code to run on activation
}

register_deactivation_hook(__FILE__, 'ampology_user_pic_deactivate');
function ampology_user_pic_deactivate() {
    // Code to run on deactivation
}