<?php

/**
 * Plugin Name: Ampology: Avada Global Container 2 Non Rendering Shortcode
 * Plugin URI: https://ampology.co.uk
 * Description: This plugin prevents global fusion containers from rendering on the page by passing them through an additional shortcode. This is useful when inserting Global Containers into code blocks and other parts of an existing page such as a modal. [ampology_fusion_global global_id='XX']
 * Author: Anthony Shapley
 * Author URI: http://ampology.co.uk
 * Version: 1.0
 */

if (!defined('ABSPATH')) {
    exit;
}

function ampology_fusion_global($atts)
{
	extract(
		shortcode_atts(
					array(
							'global_id' => 1,
							  ),
					$atts
				)
			);

	return do_shortcode('[fusion_global id="'.$global_id.'"]');

}

function ampology_register_shortcodes()
{
   add_shortcode('ampology_fusion_global', 'ampology_fusion_global');
}

add_action( 'init', 'ampology_register_shortcodes');


function ampology_primary_category_url_shortcode() {
    $post_id = get_the_ID();
    $primary_category_id = get_post_meta($post_id, '_yoast_wpseo_primary_category', true);

    if (!empty($primary_category_id)) {
        return get_category_link($primary_category_id);
    }

    return ''; // Return empty string if no primary category is set
}
add_shortcode('ampology_primary_category_url', 'ampology_primary_category_url_shortcode');


function ampology_primary_category_name_shortcode() {
    $post_id = get_the_ID();
    $primary_category_id = get_post_meta($post_id, '_yoast_wpseo_primary_category', true);

    if (!empty($primary_category_id)) {
        $primary_category = get_category($primary_category_id);
        return $primary_category->name;
    }

    return ''; // Return empty string if no primary category is set
}
add_shortcode('ampology_primary_category_name', 'ampology_primary_category_name_shortcode');

function ampology_modify_yoast_breadcrumb( $links ) {
    if ( is_single() || is_archive() ) {
        // Define the new link
        $blog_link = array(
            'url' => '/blog/',
            'text' => 'Blog'
        );

        // Check if there are at least 2 links already
        if ( count( $links ) >= 2 ) {
            // Insert the new link as the second item
            array_splice( $links, 1, 0, array( $blog_link ) );
        }
    }

    return $links;
}
add_filter( 'wpseo_breadcrumb_links', 'ampology_modify_yoast_breadcrumb' );



?>