<?php
/**
 * Plugin Name: Remove All WordPress Feeds
 * Plugin URI: https://www.anthonyshapley.com
 * Version: 0.1
 * Author: Anthony Shapley
 * Description: Removes all feeds from WordPress. This includes RSS, Atom, RDF, and all comments feeds. This plugin also removes the feed links from the header. Also fixes canonicalisation issue on blog page (ID 13)
 * 
*/

if (!defined('ABSPATH')) {
    exit;
}

function itsme_disable_feed() {
 //wp_die( __( 'No feed available, please visit the <a href="'. esc_url( home_url( '/' ) ) .'">homepage</a>!' ) );
 wp_redirect( esc_url( home_url( '/' ), 301 ) );
}

add_action('do_feed', 'itsme_disable_feed', 1);
add_action('do_feed_rdf', 'itsme_disable_feed', 1);
add_action('do_feed_rss', 'itsme_disable_feed', 1);
add_action('do_feed_rss2', 'itsme_disable_feed', 1);
add_action('do_feed_atom', 'itsme_disable_feed', 1);
add_action('do_feed_rss2_comments', 'itsme_disable_feed', 1);
add_action('do_feed_atom_comments', 'itsme_disable_feed', 1);
remove_action( 'wp_head', 'feed_links_extra', 3 );
remove_action( 'wp_head', 'feed_links', 2 );


function wpw_customize_yoast_blog_page_canonical( $canonical ) {
    // Only modify the canonical tag on a specific page, e.g., the blog page with ID 42.
    if ( is_page( 13 ) ) {
        $paged = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : 1;

        if ( $paged > 1 ) {
            // Modify the canonical URL to include the pagination.
            $canonical = trailingslashit( home_url( '/blog/' ) ) . 'page/' . $paged . '/';
        }
    }

    return $canonical;
}
add_filter( 'wpseo_canonical', 'wpw_customize_yoast_blog_page_canonical', 10, 1 );
