<?php

namespace TrunkBBI\EagleEye;

use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use TrunkBBI\EagleEye\Libraries\EagleEyeNotification;

class EagleEyeFacade {
    private bool $isProd;
    private string $baseURL;

    public function __construct()
    {
        $this->isProd = App::environment('production');
        $this->baseURL = $this->isProd ?
            'https://api.podifi.com' : 'https://demoapi.podifi.com';
    }


    public function sendNotification(EagleEyeNotification $notification) : bool
    {
        $request = Http::withHeaders($this->getAuthHeaders())
                ->withBody($notification->payload(), 'application/json')
                ->post($this->baseURL . '/qualifi/push');

        $result = $request->successful();

        if(!$result)
        {
            Log::error('Failed to send EE notification with error ('. $request->status().'): '.$request->body());
        }

        return $result;
    }

    private function getAuthHeaders() : array
    {
        return [
            'Authorization' => 'Basic ' . base64_encode(config('eagle_eye.api_key'))
        ];
    }
}