<?php

namespace TrunkBBI\EagleEye\Libraries;

class EagleEyeNotification
{
    public string $title;
    public string $message;
    public array $data;
    public array $consumer;

    public function __construct()
    {
        $this->title = config('eagleeye.notif.default_title');

        return $this;
    }

    public function payload() : string
    {
        return json_encode([
            "pushMessage" => [
                "campaignName" => config('eagleeye.notif.campaign_name'),
                "title" => $this->title,
                "message" => $this->message,
                "data" => $this->data,
            ],
            "consumer" => $this->consumer,
        ]);
    }

    public function setTitle(string $title) : EagleEyeNotification
    {
        $this->title = $title;
        return $this;
    }

    public function setMessage(string $message) : EagleEyeNotification
    {
        $this->message = $message;
        return $this;
    }

    public function setData(array $data) : EagleEyeNotification
    {
        $this->data = $data;
        return $this;
    }

    public function setConsumer(string $consumer) : EagleEyeNotification
    {
        $this->consumer = ['username' => $consumer];
        return $this;
    }
}