<?php

namespace TrunkBBI\EagleEye;

use Illuminate\Foundation\AliasLoader;
use Illuminate\Support\ServiceProvider;

class EagleEyeServiceProvider extends ServiceProvider {

    public function boot()
    {
        $loader = AliasLoader::getInstance();
        $loader->alias('EagleEye', Facades\EagleEye::class);

        $this->publishes([
            __DIR__.'/../config/eagleeye.php' => config_path('eagleeye.php'),
        ]);
    }

    public function register()
    {
        $this->app->singleton('eagle_eye', function() { return new EagleEyeService; });
    }
}