<?php

// Enqueue JavaScript file
function introducer_enqueue_custom_script() {
    wp_enqueue_script('introducer-form-handler', plugin_dir_url(__FILE__) . 'custom_form_interceptor.js', array('jquery'), '1.0', true);
}
add_action('wp_enqueue_scripts', 'introducer_enqueue_custom_script');

// Register REST API endpoint
function register_custom_endpoint() {
    register_rest_route('my-custom-form/v1', '/process/', array(
        'methods' => 'POST',
        'callback' => 'handle_form_data',
    ));
}

add_action('rest_api_init', 'register_custom_endpoint');

function handle_form_data($request) {
    // Get the raw data from the request body
    $json = $request->get_body();
    // Decode the JSON string into an associative array
    $data = json_decode($json, true);

   // Retrieve the URL from where the form was submitted
   $submitted_from = isset($data['submissionUrl']) ? $data['submissionUrl'] : 'Not provided';

    // Define the array of valid Introducer IDs
    $valid_introducer_ids = [
        203554, 58313386, 58314717,
        203568, 58313389, 58314718,
        299902, 58313390, 58314725,
        299904, 58313391, 58314727,
        299909, 56761860, 56761547,
        299911, 58313393, 58314731,
        299912, 58313394, 58314733,
        299913, 58313395, 58314734,
        299914, 58313396, 58314735,
        299916, 58313397, 58314736,
        299919, 58313398, 58314737,
        299926, 58313400, 58314738,
        299946, 58313402, 58314742,
        299952, 58313404, 58314745,
        299960, 58313407, 58314746,
        299961, 58313409, 58314747,
        299976, 58313410, 58314748,
        299979, 58313411, 58314749,
        299980, 58313412, 58314750,
        299983, 58313413, 58314751,
        299984, 58313416, 58314752,
        299987, 58313419, 58314754,
        299991, 58313421, 58314756,
        299995, 56761725, 56761424,
        800501, 58313438, 58314785,
        900100, 58313386, 58314764,
        910100, 58313386, 58314835,
        910101, 58313386, 58314769,
        2999951, 58313386, 58314770,
        2999952, 58313386, 58314772,
        2999953, 58313386, 58314773,
        2999963, 58313430, 58314779,
        2999964, 58313431, 58314781,
        100000, 58313386, 58314712,
        200000, 58313440, 58314787,
        200009, 56635946, 56635864,
        87529311, 87535653, 87529135,
        87535558, 87528936, 87535496,
        89745129, 89745145, 89745154,
        89745127, 89745132, 89745149,
        203331, 56761467, 56761762
    ];

    // Retrieve the Introducer ID from the form data
    $introducer_id = isset($data['Introducer']) ? $data['Introducer'] : '';

    // Check if the Introducer ID is in the valid list
    if (!in_array($introducer_id, $valid_introducer_ids)) {
        // If not valid, return without sending email
        return new WP_REST_Response(['status' => 'error', 'message' => 'Invalid Introducer ID'], 200);
    }

    // Look up the Introducer Name based on the Introducer ID
    $introducer_name = find_introducer_name($introducer_id);

    // Decode HTML entities in the introducer name
    $introducer_name_decoded = html_entity_decode(html_entity_decode($introducer_name, ENT_QUOTES | ENT_HTML5, 'UTF-8'));

    // Construct the email subject
    $subject = 'New Form Submission - ' . $introducer_name_decoded;

    // Add Introducer Name to the email body



    $email_to = 'leads@intasure.com,red@rcdata.co.uk';
    //$email_to = 'anthony@shapleytech.ltd.uk';
    $body = "Form Submission Details:\n\n";
    $body .= "Introducer Name: " . $introducer_name_decoded . "\n\n";
    
    foreach ($data as $name => $value) {
        if (is_array($value)) {
            $body .= sprintf("%s:\n", $name);
            foreach ($value as $item) {
                $body .= sprintf("  - %s\n", $item);
            }
        } else {
            $body .= sprintf("%s: %s\n", $name, $value);
        }
    }

    $body .= "\n-----------------\n";

    // Send the email
    $sent = wp_mail($email_to, $subject, $body);

    // Return an appropriate response
    if ($sent) {
        return new WP_REST_Response(['status' => 'success'], 200);
    } else {
        return new WP_REST_Response(['status' => 'error', 'message' => 'Failed to send email.'], 500);
    }
}

// Function to find the introducer name
function find_introducer_name($introducer_id) {
    $args = array(
        'post_type' => 'introducers',
        'meta_query' => array(
            'relation' => 'OR',
            array(
                'key' => 'ampology_default_introducer',
                'value' => $introducer_id,
                'compare' => '='
            ),
            array(
                'key' => 'ampology_acturis_uk',
                'value' => $introducer_id,
                'compare' => '='
            ),
            array(
                'key' => 'ampology_acturis_eu',
                'value' => $introducer_id,
                'compare' => '='
            )
        ),
        'posts_per_page' => 1
    );

    $query = new WP_Query($args);

    if ($query->have_posts()) {
        $query->the_post();
        return get_the_title();
    }

    return 'Unknown Introducer'; // Default value if no match is found
}
