<?php
/**
 * Plugin Name: Intasure - Introducer Tracking Plugin
 * Plugin URI: https://ampology.co.uk
 * Description: Converts introducer IDS via JSON endpoint, etc.
 * Version: 0.2
 * Author: Ampology
 * Author URI: https://ampology.co.uk
 */

if (!defined('ABSPATH')) {
    exit;
}


//require_once( plugin_dir_url(__FILE__) . '/custom_form_interceptor.php');
require_once('custom_form_interceptor.php');

/* Custom Post Type for Introducers

Table columns include:
Name
Quotex (Default)
Acturis UK
Acturis EU

*/

add_action( 'init', 'dl_introducers' );

function dl_introducers() 
{
	register_post_type( 'introducers', 
		array(
			'labels' => array(
								'name' => 'Introducers',
								'singular_name' => 'Introducer',
							),
			'description' => 'Introducer ID mapping for various tracking systems',
			'public' => false,
			'menu_position' => 30,
			'supports' => array( 'title', 'custom-fields'),
			'show_ui' => true,
		)
	);
}

/* Modify Table Columns */

add_filter( 'manage_introducers_posts_columns', 'dl_filter_posts_columns' );

function dl_filter_posts_columns( $columns )
{
	$columns = array(

		'title'  => __( 'Title' ),
		'tracking_default' => __( 'Default' ),
		'tracking_acturis_uk' => __( 'Acturis (UK)', 'dl' ), 
		'tracking_acturis_eu' => __( 'Acturis (EU)', 'dl' )
	);

	return $columns;
}

/* Populate Custom Columns - Default/Quotex */

add_action( 'manage_introducers_posts_custom_column', 'dl_introducer_column', 10, 2);

function dl_introducer_column( $column, $post_id )
{
	if ( 'tracking_default' === $column ) 
	{
		echo get_post_meta( $post_id, 'ampology_default_introducer', true );
	}

	if ( 'tracking_acturis_uk' === $column ) 
	{
		echo get_post_meta( $post_id, 'ampology_acturis_uk', true );
	}

	if ( 'tracking_acturis_eu' === $column ) 
	{
		echo get_post_meta( $post_id, 'ampology_acturis_eu', true );
	}	

}

/********
 * 
 * 
 * 	Endpoint for requesting introducer IDs
 *  from Forms.
 *  e.g. https://intasure.com/wp-json/introducer/v1/default/123
*/

add_action( 'rest_api_init', function ()
{
	register_rest_route
	( 
		'introducer/v1', 'default/(?<introducer_id>\d+)',
		array(
				'methods' => 'GET',
				'callback' => 'dl_introducer_callback',
				'args' => 
					array(
						'id' => array(
										'validate_callback' => function($param, $request, $key) 
										{
											return is_numeric( $param );
		  								}
									),
	  					),
			) 
	);
});

function dl_introducer_callback($request)
{
	$args = array(
					'post_type' => 'introducers',
					'meta_query' => array(
						array(
						'key' => 'ampology_default_introducer', 
						'value' => $request['introducer_id'], 
						'compare' => '='
						)
					),
					'posts_per_page' => 1
				);
	
	$query = new WP_Query($args);

	if(isset($query->posts[0]->ID))
	{
		$response = array(
			'request_id' => $request['introducer_id'],
			'acturis_uk_id' => get_post_meta( $query->posts[0]->ID, 'ampology_acturis_uk', true ),
			'acturis_eu_id' => get_post_meta( $query->posts[0]->ID, 'ampology_acturis_eu', true )
		);
	}
	else
	{
		$response = array(
			'request_id' => $request['introducer_id'],
			'acturis_uk_id' => 'default', //TO BE DETERMINED
			'acturis_eu_id' => 'default' // TO BE DETERMINED
		);		
	}


	return $response;
	//return $query;
}

/********************
 * 
 * 	UK Introducer ID
 *  EU Introducer ID
 * 	ROW Introducer ID
 *	Shortcodes
 * 
 * ******************/

function ampology_uk_introducer_shortcode()
{
	if(isset($_SESSION['introducer']))
	{
		$ampology_session = $_SESSION['introducer'];
	}
	else
	{
		$_SESSION['introducer'] = "200009";
	}

	$args = array(
					'post_type' => 'introducers',
					'meta_query' => array(
						array(
						'key' => 'ampology_default_introducer', 
						'value' => $_SESSION['introducer'], 
						'compare' => '='
						)
					),
					'posts_per_page' => 1
				);
	
	$query = new WP_Query($args);

	return get_post_meta( $query->posts[0]->ID, 'ampology_acturis_uk', true );
}
add_shortcode( 'introducer_uk', 'ampology_uk_introducer_shortcode' );

function ampology_eu_introducer_shortcode()
{
	if(isset($_SESSION['introducer']))
	{
		$ampology_session = $_SESSION['introducer'];
	}
	else
	{
		$_SESSION['introducer'] = "200009";
	}

	$args = array(
					'post_type' => 'introducers',
					'meta_query' => array(
						array(
						'key' => 'ampology_default_introducer', 
						'value' => $_SESSION['introducer'], 
						'compare' => '='
						)
					),
					'posts_per_page' => 1
				);
	
	$query = new WP_Query($args);

	return get_post_meta( $query->posts[0]->ID, 'ampology_acturis_eu', true );
}

add_shortcode( 'introducer_eu', 'ampology_eu_introducer_shortcode' );

/*
* Original version - didn't cover terms
*
*
*/
/*function ampology_introducer_link_generator()
{
    $response = '/quotes/holiday-home/'; // Initialize $response to ensure it's always defined

    if(get_field('_ampology_quote_or_buy') == "ampology_buy_online") {
        $url = get_field('_ampology_bo_url');
        if(empty($url)) {
            $url = "https://intasure-uk.acturis.com/AWE/Container.aspx?ProductTarget=HolidayHomes&CurrentStep=ClientDetails&Source=";
        }

        if(get_field('_ampology_introducer_location') == "EU") {
            $introducer = do_shortcode("[introducer_eu]");
        } else {
            // UK & ROW same
            $introducer = do_shortcode("[introducer_uk]");
        }
        $response = $url . $introducer;

    } elseif (get_field('_ampology_quote_or_buy') == "ampology_form") {
        
        $url = get_field("_ampology_get_a_quote_url");

        if(empty($url)) {
            $url = "/quotes/holiday-home/";
        }

        $response = $url;
    }

    return $response;
}*/

/*
*	New version covering post & term types
*
*/
function ampology_introducer_link_generator() {
    $response = '/quotes/holiday-home/'; // Default response

    // Check if we are on a singular page or a term archive
    if (is_singular()) {
        // For single posts/pages/custom post types, use the current post ID
        $context = get_the_ID();
    } elseif (is_tax() || is_category() || is_tag()) {
        // For term archives, get the queried object and build the ACF-specific term identifier
        $queried_object = get_queried_object();
        $context = $queried_object->taxonomy . '_' . $queried_object->term_id;
    } else {
        // If not a singular or term archive, default to false indicating no specific context
        $context = false;
    }

    if ($context) {
        $quote_or_buy = get_field('_ampology_quote_or_buy', $context);

        if ($quote_or_buy == "ampology_buy_online") {
            $url = get_field('_ampology_bo_url', $context);
            if (empty($url)) {
                $url = "https://intasure-uk.acturis.com/AWE/Container.aspx?ProductTarget=HolidayHomes&CurrentStep=ClientDetails&Source=";
            }

            // Assuming the introducer determination logic is correctly implemented elsewhere
            $introducer = do_shortcode("[introducer_eu]"); // Placeholder, adjust as needed

            $response = $url . $introducer;

        } elseif ($quote_or_buy == "ampology_form") {
            $url = get_field("_ampology_get_a_quote_url", $context);

            if (empty($url)) {
                $url = "/quotes/holiday-home/";
            }

            $response = $url;
        }
    }

    return $response;
}


add_shortcode('ampology_introducer_button','ampology_introducer_link_generator');

function ampology_c2a_phone_number_link()
{

    // Check if we are on a singular page or a term archive
    if (is_singular()) {
        // For single posts/pages/custom post types, use the current post ID
        $context = get_the_ID();
    } elseif (is_tax() || is_category() || is_tag() || is_author()) {
        // For term archives, get the queried object and build the ACF-specific term identifier
        $queried_object = get_queried_object();
        $context = $queried_object->taxonomy . '_' . $queried_object->term_id;
    } else {
        // If not a singular or term archive, default to false indicating no specific context
        $context = false;
    }	

	$phone_number_link = get_field("_ampology_phone_number",$context);
	if($phone_number_link)
	{
		$phone_number_link = get_field("_ampology_phone_number",$context);
	}
	else
	{
		$phone_number_link = "tel:03451110680";
	}

	$phone_number_c2a_banner = get_field("_ampology_phone_number_text_global",$context);
	if(empty($phone_number_c2a_banner))
	{
		$phone_number_c2a_banner = "0345 111 0680";
	}
	
	$text = "<a href=".$phone_number_link."><span class=\"s1\"><b>".$phone_number_c2a_banner."</b></span></a>";
	
	return $text;
}

add_shortcode("ampology_c2a_phone_number_link","ampology_c2a_phone_number_link");



add_action('template_redirect', 'introducer_tracking_code');

function introducer_tracking_code() {
    // Ensure session is started
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }

    // Default introducer ID
    $defaultIntroducerId = '200009';

    // Initially assume no change to the session value
    $newSessionValue = isset($_SESSION['introducer']) ? $_SESSION['introducer'] : $defaultIntroducerId;

    // Check for page-specific override
    $overrideIntroducer = get_field('_ampology_disable_default_introducer_tracking', get_the_ID());
    if ($overrideIntroducer[0] === "yes") {
        // Apply page-specific override
        $pageSpecificId = get_field('_ampology_default_introducer_id', get_the_ID());
        if ($pageSpecificId) {
            $newSessionValue = $pageSpecificId;
        }
    } elseif (isset($_GET['introducer'])) {
        // Apply URL parameter only if there's no page-specific override
        $newSessionValue = filter_input(INPUT_GET, 'introducer', FILTER_SANITIZE_STRING);
    }

    // Update the session with the new or unchanged value
    $_SESSION['introducer'] = $newSessionValue;
}




add_action('wp_head', 'introducer_tracking');

function introducer_tracking()
{
	echo '<script>
			console.log("Introducer: ' . htmlspecialchars($_SESSION['introducer']) . '");
			var introducer = "'.htmlspecialchars($_SESSION['introducer']).'";	

			(function($){

					jQuery( document ).ready(function()
					{

						/* injects introducer from session to all forms with ID "Introducer" */
						jQuery("#Introducer").val(introducer);

						/* Updates all links with a introducer parameter for Quotex - links to intasure.co.uk*/
						jQuery(\'a[href*="https://www.intasure.co.uk"]\').each(function()
						{
							    var $this = jQuery(this);       
							    var _href = jQuery(this).attr("href"); 

	    					    var url = jQuery(this).attr(\'href\');
							    

								/* for quotex */
							    if(url.indexOf("?"))
							    {
							    	console.log("contains query");
									$this.attr("href", _href + \'&introducer=\' + introducer);							    	
							    }
							    else
							   	{
							   		console.log("does not contain query");
									$this.attr("href", _href + \'?introducer=\' + introducer);							   		
							   	}
								console.log(url);
							    //url.appendTo.set(\'introducer\',introducer);
						});


					});
		})(jQuery);
	</script>';
}


function introducer_shortcode()
{
	return htmlentities($_SESSION['introducer']);
}

add_shortcode('introducer_id', 'introducer_shortcode');



?>