/*jQuery(document).ready(function($) {
    $('.fusion-form-form-wrapper form').on('submit', function(e) {
        e.preventDefault();

        var form = $(this);
        var formDataArray = form.serializeArray();

        // Convert the serialized array into an object, supporting array-like fields
        var formDataObject = formDataArray.reduce(function(obj, item) {
            if (obj[item.name]) {
                if (typeof(obj[item.name]) === "string") {
                    obj[item.name] = [obj[item.name]];
                }
                obj[item.name].push(item.value);
            } else {
                obj[item.name] = item.value;
            }
            return obj;
        }, {});

        // Add the current page URL to the form data object
        formDataObject.submissionUrl = window.location.href;

        // Convert the updated form data object to a JSON string
        var formDataJSON = JSON.stringify(formDataObject);

        $.ajax({
            url: '/wp-json/my-custom-form/v1/process/',
            method: 'POST',
            contentType: 'application/json', // This line is necessary for JSON data
            data: formDataJSON,
            success: function(response) {
                if (response.status === 'success') {
                    // Continue with the normal form submission
                    form.off('submit').submit();
                }
            },
            error: function() {
                // Handle error
                alert('An error occurred');
            }
        });
    });
});*/
jQuery(document).ready(function($) {
    $('.fusion-form-form-wrapper form').on('submit', function(e) {
        var AmpIntForm = $(this); // Renamed variable to AmpIntForm

        // Prevent the default submission only for the initial submit event
        if (!e.originalEvent) {
            return; // Let the re-triggered submit event proceed
        }
        e.preventDefault();

        var formDataArray = AmpIntForm.serializeArray();

        // Convert the serialized array into an object
        var formDataObject = formDataArray.reduce(function(obj, item) {
            if (obj[item.name]) {
                if (typeof(obj[item.name]) === "string") {
                    obj[item.name] = [obj[item.name]];
                }
                obj[item.name].push(item.value);
            } else {
                obj[item.name] = item.value;
            }
            return obj;
        }, {});

        // Add the current page URL to the form data object
        formDataObject.submissionUrl = window.location.href;

        // Convert the updated form data object to a JSON string
        var formDataJSON = JSON.stringify(formDataObject);

        $.ajax({
            url: '/wp-json/my-custom-form/v1/process/',
            method: 'POST',
            contentType: 'application/json',
            data: formDataJSON,
            complete: function() {
                // Submit the form after the AJAX request completes, regardless of success or error
                AmpIntForm.off('submit').submit();
            },
            error: function() {
                // You can still handle the error, e.g., log it or show an alert
                AmpIntForm.off('submit').submit();
            }
        });
    });
});
