<?php

namespace TrunkBBI\Livescore;

use Illuminate\Support\Facades\Http;

class LivescoreFacade {
    private const BaseURL = "https://livescore-api.com/api-client/";

    private $baseRequestParams;

    public function __construct()
    {
        $this->baseRequestParams = [
            'key' => config('livescore.key'),
            'secret' => config('livescore.secret')
        ];
        return $this;
    }


    public function fixtures(string $team_id = null, string $competition_id = null)  {

        $params = [];
        if($team_id) $params['team_id'] = $team_id;
        if($competition_id) $params['competition_id'] = $competition_id;

        $response  = Http::withQueryParameters(array_merge($this->baseRequestParams, $params))
        ->get(self::BaseURL . 'fixtures/matches.json');

        if($response->successful() && $response->json('success', false)) {
            return $response['data']['fixtures'];
        } else {
            return null;
        }
    }

    public function live(string $fixture_id)
    {
        $response  = Http::withQueryParameters(array_merge($this->baseRequestParams, [
            'fixture_id' => $fixture_id,
        ]))
        ->get(self::BaseURL . 'matches/live.json');

        if($response->successful() && $response->json('success', false) && !empty($response['data']['match'])) {
            return $response['data']['match'][0];
        } else {
            return null;
        }
    }

    public function events(string $match_id)
    {
        $response  = Http::withQueryParameters(array_merge($this->baseRequestParams, [
            'id' => $match_id,
        ]))
        ->get(self::BaseURL . 'scores/events.json');

        if($response->successful() && $response->json('success', false)) {
            return $response['data'];
        } else {
            return null;
        }
    }

}