<?php

namespace TrunkBBI\Livescore;

use Illuminate\Foundation\AliasLoader;
use Illuminate\Support\ServiceProvider;

class LivescoreServiceProvider extends ServiceProvider {

    public function boot()
    {
        $loader = AliasLoader::getInstance();
        $loader->alias('Livescore', Facades\Livescore::class);

        $this->publishes([
            __DIR__.'/../config/livescore.php' => config_path('livescore.php'),
        ]);
    }

    public function register()
    {
        $this->app->singleton('livescore', function() { return new LivescoreFacade; });
    }
}