<?php

namespace Tbbi\AcfComponentLink;

use WP_Query;
use WP_Error;

class TbbiAcfFieldComponentLink extends \acf_field
{
    public $show_in_rest = true;
    private $env;

    public function __construct()
    {
        if (!defined('ABSPATH')) {
            exit;
        }

        $this->name = 'component_link';
        $this->label = __('Component Link', 'trunkbbi-acf-component-link');
        $this->category = 'basic';
        $this->doc_url = '';
        $this->tutorial_url = '';
        $this->description = __(
            'This field can create links directly to page components',
            'trunkbbi-acf-component-link'
        );
        $this->defaults = array();
        $this->l10n = array(
            'error' => __('Error! Please enter a higher value', 'trunkbbi-acf-component-link')
        );
        $this->env = array(
            'url' => site_url(str_replace(ABSPATH, '', __DIR__)),
            'version' => '0.1'
        );

        add_action('wp_ajax_page_search', [$this , 'getPages']);
        add_action('wp_ajax_page_comp_list', [$this, 'getPageFields']);

        parent::__construct();
    }

    public function render_field($field)
    {
        $pages = json_decode($this->getPages('return'), true);
        $id = preg_replace('/[^A-Za-z0-9\-]/', '', $field['name']);
        $current_value = json_decode($field['value']);
?>
        <div class="component-link" style="display: flex;">
            <div style="width:33%; min-height:92px; padding:16px;">
                <div class="acf-label">
                    <label for="component-dropdown-one">Page</label>
                </div>
                <select name="component-dropdown-one" id="js-dropdown-one-<?php echo $id; ?>">
<?php
        $selected = '';

        if (is_object($current_value) && property_exists($current_value, 'page') && $current_value->page == '') {
            
            $selected = 'selected';
        }
        echo '<option value="" ' . $selected . ' >Select Page</option>';

        foreach ($pages as $page) {
            $selected = '';

            if (is_object($current_value) && property_exists($current_value, 'page') && $current_value->page != '') {
                if ($current_value->page == $page['id']) {
                    $selected = 'selected';
                }
            }
            echo '<option value="' . $page['id'] . '" ' . $selected . '>' . $page['title'] . '</option>';
        }
?>
                </select>
            </div>
            <div style="width:33%; min-height:92px; border-left:1px solid #eeeeee; border-right:1px solid #eeeeee; padding:16px;">
                <div class="acf-label">
                    <label for="component-dropdown-two">Page Builder Element</label>
                </div>
                <select class="" name="component-dropdown-two" id="js-dropdown-two-<?php echo $id; ?>" disabled>
                    <option value="">Select Element</option>
                </select>
            </div>
            <div style="width:33%; min-height:92px; padding:16px;">
                <div class="acf-label">
                    <label for="component-link-text">Link text</label>
                </div>
<?php
                $value = '';
                if (is_object($current_value) && property_exists($current_value, 'text') && $current_value->text != '') {
                    $value = $current_value->text;
                }
?>
                <input type="text" name="component-link-text" id="js-dropdown-three-<?php echo $id; ?>" value="<?php echo $value; ?>">
            </div>
<?php

        printf(
            '<input type="hidden" name="%s" value="%s" id="%s">',
            esc_attr($field['name']),
            esc_attr($field['value']),
            esc_attr('js-save-' . $id)
        );
?>
            <script>
                jQuery(document).ready(function() {
                    const id = '<?php echo $id; ?>';

                    function updateResultField()
                    {
                        let save_data = {
                            'page': jQuery('#js-dropdown-one-'+id).val(),
                            'element': jQuery('#js-dropdown-two-'+id).val(),
                            'text': jQuery('#js-dropdown-three-'+id).val()
                        };
                    
                        jQuery('#js-save-'+id).val(JSON.stringify(save_data));
                    }

                    function updateElementDropdown()
                    {
                        let set_values;

                        if(jQuery('#js-save-'+id).val() !== '') {
                            set_values = JSON.parse(jQuery('#js-save-'+id).val());
                        }

                        jQuery.ajax({
                            type: "post",
                            dataType: "json",
                            url: ajaxurl,
                            data: {
                                action: "page_comp_list",
                                pid: jQuery('#js-dropdown-one-'+id).val()
                            },
                            success: function(response) {
                                let json = response;
                                jQuery('#js-dropdown-two-'+id).empty();

                                if (json.length <= 0) {
                                    jQuery('#js-dropdown-two-'+id).prop('disabled', true);
                                } else {
                                    jQuery('#js-dropdown-two-'+id)
                                        .prop('disabled', false)
                                        .append(new Option('Select Element', ''));

                                    for (let i=0; i<json.length; i++) {

                                        if (set_values.hasOwnProperty('element') && set_values.element === json[i]["unique_id"]) {
                                            jQuery('#js-dropdown-two-'+id).append(new Option(
                                                'Row '+i+' - '+json[i]["name"],
                                                json[i]["unique_id"],
                                                true,
                                                true
                                            ));
                                        } else {
                                            jQuery('#js-dropdown-two-'+id).append(new Option(
                                                'Row '+i+' - '+json[i]["name"],
                                                json[i]["unique_id"]
                                            ));
                                        }
                                    }
                                }

                                updateResultField();
                            }
                        });
                    }

                    // Run on page load
                    updateElementDropdown();
                    jQuery('#js-dropdown-one-'+id).on('change',  updateElementDropdown);

                    jQuery('#js-dropdown-two-'+id).on('change',  updateResultField);
                    jQuery('#js-dropdown-three-'+id).on('keyup',  updateResultField);
                });
            </script>
        </div>
<?php
    }

    public function getPageFields()
    {
        $fields = get_fields($_POST['pid']);
        $result = array();

        if (is_array($fields)) {
            if (array_key_exists('page_builder', $fields)) {
                foreach ($fields['page_builder'] as $component) {
                    if (array_key_exists('unique_id', $component)) {
                        $result[] = array(
                            'unique_id' => $component['unique_id'],
                            'name' => $component['acf_fc_layout']
                        );
                    }
                }
            }
        }

        echo json_encode($result);
        die();
    }

    public function getPages($return = false)
    {
        $return_array = array();

        $page_list = get_posts(array(
            'numberposts' => -1,
            'post_type' => 'page'
        ));

        if (!empty($page_list)) {
            foreach ($page_list as $p) {
                $arr = array(
                    'id' => $p->ID,
                    'title' => get_the_title($p->ID)
                );
                array_push($return_array, $arr);
            }
        }

        $json = json_encode($return_array);

        if ($return) {
            return $json;
        }

        echo $json;
        die();
    }

    function update_value( $value, $post_id, $field ) {

        if (empty($value)) {
            $value = '';
        }

        return $value;
    }

    public function format_value($value, $post_id, $field)
    {
        if (!isset($value)) {
            return "";
        }
        $current_value = json_decode($value);

        if (is_object($current_value)) {

            return [
                'permalink' => get_the_permalink($current_value->page),
                'anchor' => $current_value->element,
                'title' => $current_value->text
            ];
        } else {
            return [
                'permalink' => '',
                'anchor' => '',
                'title' => ''
            ];
        }
    }
}
