<?php

namespace Tbbi\AcfComponentLink;

class TbbiAcfFieldUniqueId extends \acf_field
{
    public $show_in_rest = true;
    private $env;

    public function __construct()
    {
        if (!defined('ABSPATH')) {
            exit;
        }

        $this->name = 'unique_id';
        $this->label = __('Unique ID', 'acf-component-link');
        $this->category = 'basic';
        $this->description = __('Generates a unique ID for the field group', 'acf-component-link');
        $this->doc_url = '';
        $this->tutorial_url = '';
        $this->defaults = array();
        $this->l10n = array('error' => __('Error! Please enter a higher value', 'acf-component-link'));
        $this->env = array(
            'url' => site_url(str_replace(ABSPATH, '', __DIR__)),
            'version' => '0.0.1',
        );
        $this->preview_image = $this->env['url'] . '/assets/images/field-preview-custom.png';

        add_action('acf/input/admin_footer', [$this, 'addJavascript']);

        parent::__construct();
    }

    public function render_field($field)
    {
        echo '<div class="unique-id">';
        echo '<p><em>This value can be changed if required. Note that should any link already be in place, they will need to be re-connected should you change this field.</em></p>';
        printf(
            '<input type="text" name="%s" value="%s">',
            esc_attr($field['name']),
            esc_attr($field['value'])
        );
        echo '</div>';
    }

    public function input_admin_enqueue_scripts()
    {
        $url = trailingslashit($this->env['url']);
        $version = $this->env['version'];
    }

    public function addJavascript()
    {
?>
        <script type="text/javascript">
            (function($) {
                acf.add_action('append', function($el) {
                    let uuid = "10000000".replace(/[018]/g, c => (c ^ crypto.getRandomValues(new Uint8Array(1))[0] & 15 >> c / 4).toString(16)),
                        input = $el.find('.unique-id').find('input');
                    if (!input.val()) {
                        input.val(uuid);
                    }
                });
            })(jQuery); 
        </script>
<?php
    }
}
