<?php

namespace Tbbi\AcfComponentLink;

class TbbiAcfFieldUniqueId extends \acf_field
{
    public $show_in_rest = true;
    private $env;

    public function __construct()
    {
        if (!defined('ABSPATH')) {
            exit;
        }

        $this->name = 'unique_id';
        $this->label = __('Unique ID', 'acf-component-link');
        $this->category = 'basic';
        $this->description = __('Generates a unique ID for the field group', 'acf-component-link');
        $this->doc_url = '';
        $this->tutorial_url = '';
        $this->defaults = array();
        $this->l10n = array('error' => __('Error! Please enter a higher value', 'acf-component-link'));
        $this->env = array(
            'url' => site_url(str_replace(ABSPATH, '', __DIR__)),
            'version' => '0.0.1',
        );
        $this->preview_image = $this->env['url'] . '/assets/images/field-preview-custom.png';

        parent::__construct();
    }

    private function generateUuid()
    {

        // TODO(Liam): prefix the returned id with the type of component

        return uniqid();
    }

    /**
     * HTML content to show when a publisher edits the field on the edit screen.
     *
     * @param array $field The field settings and values.
     * @return void
     */
    public function render_field($field)
    {
        if ($field['value'] == '') {
            $field['value'] = $this->generateUuid();
        }


        printf(
            '<input type="text" name="%s" value="%s" readonly>',
            esc_attr($field['name']),
            esc_attr($field['value'])
        );
    }

    /**
     * Enqueues CSS and JavaScript needed by HTML in the render_field() method.
     *
     * Callback for admin_enqueue_script.
     *
     * @return void
     */
    public function input_admin_enqueue_scripts()
    {
        $url = trailingslashit($this->env['url']);
        $version = $this->env['version'];
    }
}
