/**
 * Included when component_link fields are rendered for editing by publishers.
 */
(function ($) {
	function initialize_field($field) {
		/**
		 * $field is a jQuery object wrapping field elements in the editor.
		 */
		[...document.querySelectorAll('.component-link')].forEach((element) => {
			let textElement = element.querySelector('.search-text');
			let list  = element.querySelector('#page-list');

			textElement.addEventListener('input', () => {
				
					const requestData = {
						action: 'page_search',
						search: element.querySelector('.search-text').value,
					};
	
					fetch(ajaxurl, {
						method: "post",
						headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
						body: new URLSearchParams(requestData).toString(),
					}).then(response => {
						console.log(response);
						let response_body = response.text().then(function (body) {
							let pageData = JSON.parse(body);
							list.replaceChildren();
							pageData.map((data) => {
								let option = document.createElement('option');
								option.id = data.id;
								option.value = data.title;
								option.innerHTML = data.title;
								list.appendChild(option);

								return option;
							});
						});
					});


			});

			// [...element.querySelectorAll('.js-add-link')].forEach((button) => {
			// 	button.addEventListener('click', () => {
			// });
		// });
		});
	}

	if (typeof acf.add_action !== 'undefined') {
		/**
		 * Run initialize_field when existing fields of this type load,
		 * or when new fields are appended via repeaters or similar.
		 */
		acf.add_action('ready_field/type=component_link', initialize_field);
		acf.add_action('append_field/type=component_link', initialize_field);
	}
})(jQuery);