
(function ($) {
	function initialize_field($field) {
		const id = $field.find('.component-link').data('component-id');

		const $pageDrowpdown = jQuery('[data-select-id-one='+id+']:last');
		const $compoentDropdown = jQuery('[data-select-id-two='+id+']:last');
		const $labelField = jQuery('[data-select-id-three='+id+']:last');
		const $saveData = jQuery('[data-id-save='+id+']:last');
		function updateElementDropdown() {
			let set_values;
			if ($saveData.val()) {
				set_values = JSON.parse($saveData.val());
			}

			jQuery.ajax({
				type: "post",
				dataType: "json",
				url: ajaxurl,
				data: {
					action: "page_comp_list",
					pid: $pageDrowpdown.val()
				},
				success: function (response) {
					let json = response;
					$compoentDropdown.empty();

					if (json.length <= 0) {
						$compoentDropdown.prop('disabled', true);
					} else {
						$compoentDropdown
							.prop('disabled', false)
							.append(new Option('Select Element', ''));

						for (let i = 0; i < json.length; i++) {

							if (set_values.hasOwnProperty('element') && set_values.element === json[i]["unique_id"]) {
								$compoentDropdown.append(new Option(
									'Row ' + i + ' - ' + json[i]["name"],
									json[i]["unique_id"],
									true,
									true
								));
							} else {
								$compoentDropdown.append(new Option(
									'Row ' + i + ' - ' + json[i]["name"],
									json[i]["unique_id"]
								));
							}
						}
					}


					updateResultField();
				}
			});
		}
		function updateResultField()
					{
						let save_data = {
							'page': $pageDrowpdown.val(),
							'element': $compoentDropdown.val(),
							'text': $labelField.val()
						};
						$saveData.val(JSON.stringify(save_data));
					}
		updateElementDropdown();

		$pageDrowpdown.on('change', updateElementDropdown);
		$compoentDropdown.on('change',  updateResultField);
		$labelField.on('keyup',  updateResultField);
	}

	if (typeof acf.add_action !== 'undefined') {
		acf.add_action('ready_field/type=component_link', initialize_field);
		acf.add_action('append_field/type=component_link', initialize_field);
	}
})(jQuery);