<?php

/*
 * Plugin Name: TrunkBBI ACF Component Link
 * Plugin URI: https://trunkbbi.com
 * Author: TrunkBBI
 * Author URI: https://trunkbbi.com
 * Description: TrunkBBI custom plugin to allow for ACF field linkings
 * Version: 0.0.2
 */

namespace Tbbi\AcfComponentLink;

if (!class_exists('ComponentLinkPlugin')) {

    class ComponentLinkPlugin
    {
        public function __construct()
        {
            if (!defined('ABSPATH')) {
                exit;
            }

            require_once plugin_dir_path(__FILE__) . '/autoloader.php';

            register_activation_hook(__FILE__, [$this, 'activatePlugin']);
            register_deactivation_hook(__FILE__, [$this, 'deactivatePlugin']);

            $this->setup();
        }

        public function activatePlugin()
        {
            if (!class_exists('ACF')) {
                deactivate_plugins(plugin_basename(__FILE__));
                wp_die(__('ACF Pro is required for this plugin to work', 'tbbi-component'));
            }
        }

        public function deactivatePlugin()
        {
            // Optional, may be needed to clear data
        }

        public function setup()
        {
            new ComponentLink();
            new UniqueId();
        }
    }
}

new ComponentLinkPlugin();
