<?php

    namespace Tbbi\CF;

class CaterforceAuth
{
    private const AKENEO_BASE_URL = 'https://caterforce.cloud.akeneo.com/';
    private const AKENEO_AUTH = 'api/oauth/v1/token';
    private const ADMIN_PAGE = 'options-general.php?page=akeneo-pim-menu.php';

    private $client_id;
    private $client_secret;
    private $client_refresh;

    public function __construct()
    {
        $this->client_id = get_option('cf-id');
        $this->client_secret = get_option('cf-secret');
        $this->client_refresh = get_option('cf-refresh');

        add_action('admin_post_get_cf_token', [$this, 'getOauthToken']);
        add_action('admin_post_renew_cf_token', [$this, 'renewOauthToken']);
        add_action('admin_post_destroy_cf_token', [$this, 'destroyOauthToken']);
    }

    private function makeRequest($body, $endpoint)
    {
        $headers = array(
            'Authorization' => 'Basic ' . base64_encode($this->client_id . ':' . $this->client_secret),
            'Content-Type' => 'application/json',
        );

        $args = array(
            'headers' => $headers,
            'body' => $body
        );

        return wp_remote_post($this::AKENEO_BASE_URL . $endpoint, $args);
    }

    public function getOauthToken()
    {
        if (!isset($_POST['cf-username']) || !isset($_POST['cf-password'])) {
            wp_redirect(admin_url($this::ADMIN_PAGE));
            die();
        }

        $username = $_POST['cf-username'];
        $password = $_POST['cf-password'];

        update_option('cf-id', $_POST['cf-id']);
        update_option('cf-secret', $_POST['cf-secret']);

        $this->client_id = get_option('cf-id');
        $this->client_secret = get_option('cf-secret');

        $body = json_encode(array(
            'username' => $username,
            'password' => $password,
            'grant_type' => 'password',
        ));
        $response = $this->makeRequest($body, $this::AKENEO_AUTH);

        if (!$response) {
            wp_redirect(admin_url($this::ADMIN_PAGE));
            die();
        }

        $data = json_decode(wp_remote_retrieve_body($response), true);
        if (!isset($data['access_token'], $data['expires_in'], $data['refresh_token'])) {
            wp_redirect(admin_url($this::ADMIN_PAGE));
            die();
        }

        update_option('cf-token', $data['access_token']);
        update_option('cf-refresh', $data['refresh_token']);
        wp_redirect(admin_url($this::ADMIN_PAGE));
        die();
    }


    public function renewOauthToken()
    {
        $body = json_encode(array(
            'refresh_token' => $this->client_refresh,
            'grant_type' => 'refresh_token',
        ));

        $response = $this->makeRequest($body, $this::AKENEO_AUTH);

        if (!$response) {
            wp_redirect($this::ADMIN_PAGE);
            die();
        }

        $data = json_decode(wp_remote_retrieve_body($response), true);

        if (!isset($data['access_token'], $data['expires_in'], $data['refresh_token'])) {
            wp_redirect(admin_url($this::ADMIN_PAGE));
            die();
        }

        update_option('cf-token', $data['access_token']);
        update_option('cf-refresh', $data['refresh_token']);
        wp_redirect(admin_url($this::ADMIN_PAGE));
        die();
    }

    public function destroyOauthToken()
    {
        update_option('cf-id', null);
        update_option('cf-secret', null);
        update_option('cf-token', null);
        update_option('cf-refresh', null);
        wp_redirect(admin_url('options-general.php?page=akeneo-pim-menu.php'));
        die();
    }
}
