<?php

namespace Tbbi\CF;

class CaterforceSettings
{
    public function __construct()
    {
        add_action('init', [$this, 'createCpt']);
        add_action('init', [$this, 'createTax']);
        add_action('acf/include_fields', [$this, 'createAcf']);

        add_action('admin_menu', function () {
            add_submenu_page(
                null,
                'Akeneo PIM',
                'Akeneo PIM',
                'manage_options',
                'akeneo-pim-menu',
                [$this, 'pluginAdminPage']
            );
        });

        add_filter("plugin_action_links_trunk-bbi-caterforce/trunk-bbi-caterforce.php", function ($links) {
            $settings_link = '<a href="options-general.php?page=akeneo-pim-menu.php">Settings</a>';
            array_unshift($links, $settings_link);
            return $links;
        });

        add_filter('manage_members-qas_posts_columns', [$this ,'createCptColumns'], 5);
        add_action('manage_members-qas_posts_custom_column', [$this ,'fillCptColumns'], 5, 2);
        add_action('admin_head', [$this ,'styleColumns']);
    }

    /**
     * Set up the admin page
     *
     * @return void
     */
    public function pluginAdminPage()
    {
        include(plugin_dir_path(__FILE__) . 'CaterforceAdmin.php');
    }

    /**
     * Create the CPT
     *
     * @return void
     */
    public function createCpt()
    {
        if (post_type_exists('members-qas')) {
            return;
        }

        $args = array(
            'label' => 'Member QAS',
            'labels' => array(

            ),
            'description' => 'Test',
            'public' => true,
            'show_ui' => true,
            'menu_icon' => 'dashicons-groups',
            'supports' => array(
                'title',
                'editor',
                'revisions'
            )
        );

        register_post_type('members-qas', $args);
    }

    public function createCptColumns($columns)
    {
        $new = array();
        foreach ($columns as $key => $value) {
            if ($key == 'date') {
                $new['identifier'] = 'Identifier';
                $new['brand'] = 'Brand';
            }
            if ($key == 'title') {
                $new['image'] = 'Image';
            }
            $new[$key] = $value;
        }
        return $new;
    }

    public function fillCptColumns($name, $id)
    {
        global $post;
        if ($name === 'image') {
            if (have_rows('product_images', $id)) {
                while (have_rows('product_images', $id)) {
                    the_row();
                    $image = get_sub_field('image');
                    if (is_array($image)) {
                        echo '<img src="' . $image['sizes']['thumbnail'] . '" width="50px" height="50px">';
                        break;
                    }
                }
            }
        }

        if ($name === 'identifier') {
            echo get_field('product_identifier', $id);
        }

        if ($name === 'brand') {
            $brands = get_the_terms($id, 'brands');
            foreach ($brands as $brand) {
                echo $brand->name;
            }
        }
    }

    public function styleColumns()
    {
        $screen = get_current_screen();
        if ($screen->id == 'edit-members-qas') {
            echo '<style>.column-image {width: 100px;} .column-image img, { width:80px; height: auto; }</style>';
        }
    }

    public function createTax()
    {
        register_taxonomy('allergens', 'members-qas', array(
            'hierarchical' => false,
            'public' => false,
            'labels' => array(
                'name' => 'Allergens',
                'singular_name' => 'Allergen',
                'search_items' => 'Search Allergens',
                'all_items' => 'All Allergens',
                'parent_item' => 'Parent Allergen',
                'parent_item_colon' => 'Parent Allergen:',
                'edit_item' => 'Edit Allergen',
                'update_item' => 'Update Allerges',
                'add_new_item' => 'Add new allergen',
                'new_item_name' => 'New allergen name',
                'menu_name' => 'Allergens'
            ),
            'rewrite' => array(
                'slug' => 'allergens',
                'with_front' => false,
                'hierarchical' => false
            )
        ));

        register_taxonomy('diet', 'members-qas', array(
            'hierarchical' => false,
            'public' => false,
            'labels' => array(
                'name' => 'Diet',
                'singular_name' => 'Diet',
                'search_items' => 'Search Diets',
                'all_items' => 'All Diets',
                'parent_item' => 'Parent Diet',
                'parent_item_colon' => 'Parent Diet:',
                'edit_item' => 'Edit Diet',
                'update_item' => 'Update Diet',
                'add_new_item' => 'Add new diet',
                'new_item_name' => 'New diet name',
                'menu_name' => 'Diet'
            ),
            'rewrite' => array(
                'slug' => 'diet',
                'with_front' => false,
                'hierarchical' => false
            )
        ));

        register_taxonomy('product-category', 'members-qas', array(
            'hierarchical' => false,
            'public' => false,
            'labels' => array(
                'name' => 'Categories',
                'singular_name' => 'Category',
                'search_items' => 'Search Categories',
                'all_items' => 'All Categories',
                'parent_item' => 'Parent Category',
                'parent_item_colon' => 'Parent Category:',
                'edit_item' => 'Edit Category',
                'update_item' => 'Update Category',
                'add_new_item' => 'Add new category',
                'new_item_name' => 'New category name',
                'menu_name' => 'Categories'
            ),
            'rewrite' => array(
                'slug' => 'categories',
                'with_front' => false,
                'hierarchical' => false
            )
        ));

        register_taxonomy('brands', 'members-qas', array(
            'hierarchical' => false,
            'public' => false,
            'labels' => array(
                'name' => 'Brands',
                'singular_name' => 'Brands',
                'search_items' => 'Search Brands',
                'all_items' => 'All Brands',
                'parent_item' => 'Parent Brand',
                'parent_item_colon' => 'Parent Brand:',
                'edit_item' => 'Edit Brand',
                'update_item' => 'Update Brand',
                'add_new_item' => 'Add new brand',
                'new_item_name' => 'New brand name',
                'menu_name' => 'Brands'
            ),
            'rewrite' => array(
                'slug' => 'brands',
                'with_front' => false,
                'hierarchical' => false
            )
        ));
    }

    public function createAcf()
    {
        add_action('acf/include_fields', function () {
            if (!function_exists('acf_add_local_field_group')) {
                return;
            }

            acf_add_local_field_group( array(
                'key' => 'group_64e8c5ab1c207',
                'title' => 'Products',
                'fields' => array(
                    array(
                        'key' => 'field_64e8c84882353',
                        'label' => 'Product General',
                        'name' => '',
                        'aria-label' => '',
                        'type' => 'accordion',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'open' => 0,
                        'multi_expand' => 0,
                        'endpoint' => 0,
                    ),
                    array(
                        'key' => 'field_64e8c74801a67',
                        'label' => 'Product Identifier',
                        'name' => 'product_identifier',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64f87096765e8',
                        'label' => 'Product GTIN',
                        'name' => 'product_gtin',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64f9eba57d5c4',
                        'label' => 'Product CSBC',
                        'name' => 'product_csbc',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64f86ff6765e6',
                        'label' => 'Product Supplier',
                        'name' => 'product_supplier',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64f8700f765e7',
                        'label' => 'Product Supplier Code',
                        'name' => 'product_supplier_code',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64f87b20cb2de',
                        'label' => 'Erudus ID',
                        'name' => 'erudus_id',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64f87b32cb2df',
                        'label' => 'Erudus Status',
                        'name' => 'erudus_status',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64f87fa1e41a2',
                        'label' => 'Country Of Origin',
                        'name' => 'country_of_origin',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64e8c7fe8d0e7',
                        'label' => 'Product Overview',
                        'name' => 'product_overview',
                        'aria-label' => '',
                        'type' => 'wysiwyg',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'tabs' => 'visual',
                        'toolbar' => 'full',
                        'media_upload' => 0,
                        'delay' => 0,
                    ),
                    array(
                        'key' => 'field_64e8c774301c8',
                        'label' => 'Product Information',
                        'name' => '',
                        'aria-label' => '',
                        'type' => 'accordion',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'open' => 0,
                        'multi_expand' => 0,
                        'endpoint' => 0,
                    ),
                    array(
                        'key' => 'field_64e8c8ad7069f',
                        'label' => 'Storage',
                        'name' => 'product_storage',
                        'aria-label' => '',
                        'type' => 'textarea',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'rows' => 4,
                        'placeholder' => '',
                        'new_lines' => '',
                    ),
                    array(
                        'key' => 'field_64e8c8b4706a0',
                        'label' => 'Directions',
                        'name' => 'product_directions',
                        'aria-label' => '',
                        'type' => 'textarea',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'rows' => 4,
                        'placeholder' => '',
                        'new_lines' => '',
                    ),
                    array(
                        'key' => 'field_64f8711c765e9',
                        'label' => 'Ingredients',
                        'name' => 'product_ingredients',
                        'aria-label' => '',
                        'type' => 'textarea',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'rows' => 4,
                        'placeholder' => '',
                        'new_lines' => '',
                    ),
                    array(
                        'key' => 'field_64f9d38b89852',
                        'label' => 'Product Taxonomies',
                        'name' => '',
                        'aria-label' => '',
                        'type' => 'accordion',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'open' => 0,
                        'multi_expand' => 0,
                        'endpoint' => 0,
                    ),
                    array(
                        'key' => 'field_64f9d39b89853',
                        'label' => 'Diet',
                        'name' => 'product_taxonomies',
                        'aria-label' => '',
                        'type' => 'taxonomy',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '25',
                            'class' => '',
                            'id' => '',
                        ),
                        'taxonomy' => 'diet',
                        'add_term' => 0,
                        'save_terms' => 0,
                        'load_terms' => 1,
                        'return_format' => 'id',
                        'field_type' => 'multi_select',
                        'allow_null' => 1,
                        'multiple' => 0,
                    ),
                    array(
                        'key' => 'field_64f9d3f1e242a',
                        'label' => 'Allergens',
                        'name' => 'allergens',
                        'aria-label' => '',
                        'type' => 'taxonomy',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '25',
                            'class' => '',
                            'id' => '',
                        ),
                        'taxonomy' => 'allergens',
                        'add_term' => 0,
                        'save_terms' => 0,
                        'load_terms' => 1,
                        'return_format' => 'id',
                        'field_type' => 'multi_select',
                        'allow_null' => 1,
                        'multiple' => 0,
                    ),
                    array(
                        'key' => 'field_64f9d40de242b',
                        'label' => 'Category',
                        'name' => 'category',
                        'aria-label' => '',
                        'type' => 'taxonomy',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '25',
                            'class' => '',
                            'id' => '',
                        ),
                        'taxonomy' => 'product-category',
                        'add_term' => 0,
                        'save_terms' => 0,
                        'load_terms' => 1,
                        'return_format' => 'id',
                        'field_type' => 'multi_select',
                        'allow_null' => 1,
                        'multiple' => 0,
                    ),
                    array(
                        'key' => 'field_64f9d41ee242c',
                        'label' => 'Brand',
                        'name' => 'brand',
                        'aria-label' => '',
                        'type' => 'taxonomy',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '25',
                            'class' => '',
                            'id' => '',
                        ),
                        'taxonomy' => 'brands',
                        'add_term' => 0,
                        'save_terms' => 0,
                        'load_terms' => 1,
                        'return_format' => 'id',
                        'field_type' => 'multi_select',
                        'allow_null' => 1,
                        'multiple' => 0,
                    ),
                    array(
                        'key' => 'field_64e8c78b301c9',
                        'label' => 'Product Images',
                        'name' => '',
                        'aria-label' => '',
                        'type' => 'accordion',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'open' => 0,
                        'multi_expand' => 0,
                        'endpoint' => 0,
                    ),
                    array(
                        'key' => 'field_64f8a5ba9ac54',
                        'label' => 'Images',
                        'name' => 'product_images',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'table',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_64f8a5cb9ac55',
                                'label' => 'Image',
                                'name' => 'image',
                                'aria-label' => '',
                                'type' => 'image',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'library' => 'all',
                                'min_width' => '',
                                'min_height' => '',
                                'min_size' => '',
                                'max_width' => '',
                                'max_height' => '',
                                'max_size' => '',
                                'mime_types' => '',
                                'preview_size' => 'medium',
                                'parent_repeater' => 'field_64f8a5ba9ac54',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_64e8c78e301ca',
                        'label' => 'Product Downloads',
                        'name' => '',
                        'aria-label' => '',
                        'type' => 'accordion',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'open' => 0,
                        'multi_expand' => 0,
                        'endpoint' => 0,
                    ),
                    array(
                        'key' => 'field_64e8c8c0706a1',
                        'label' => 'Downloads',
                        'name' => 'product_downloads',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'table',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_64e8c8da706a2',
                                'label' => 'Title',
                                'name' => 'title',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '66',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_64e8c8c0706a1',
                            ),
                            array(
                                'key' => 'field_64e8c8ee706a3',
                                'label' => 'File',
                                'name' => 'file',
                                'aria-label' => '',
                                'type' => 'file',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '33',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'url',
                                'library' => 'all',
                                'min_size' => '',
                                'max_size' => '',
                                'mime_types' => '',
                                'parent_repeater' => 'field_64e8c8c0706a1',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_64e8c7ce00365',
                        'label' => '',
                        'name' => '',
                        'aria-label' => '',
                        'type' => 'accordion',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'open' => 0,
                        'multi_expand' => 0,
                        'endpoint' => 1,
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'post_type',
                            'operator' => '==',
                            'value' => 'members-qas',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => array(
                    0 => 'the_content',
                    1 => 'excerpt',
                    2 => 'discussion',
                    3 => 'comments',
                    4 => 'revisions',
                    5 => 'slug',
                    6 => 'author',
                    7 => 'format',
                    8 => 'page_attributes',
                    9 => 'featured_image',
                    10 => 'categories',
                    11 => 'tags',
                    12 => 'send-trackbacks',
                ),
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
            ) );


            acf_add_local_field_group(array(
                'key' => 'group_64f9a9cc60d18',
                'title' => 'Brands',
                'fields' => array(
                    array(
                        'key' => 'field_64f9a9d24e98f',
                        'label' => 'Brand Used',
                        'name' => 'brand_used',
                        'aria-label' => '',
                        'type' => 'true_false',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'message' => '',
                        'default_value' => 0,
                        'ui_on_text' => '',
                        'ui_off_text' => '',
                        'ui' => 1,
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'taxonomy',
                            'operator' => '==',
                            'value' => 'brands',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
            ));
        });
    }
}
