<?php
    $show_login = false;
    $show_client = false;

if ((get_option('cf-token') == "") || (get_option('cf-refresh') == "")) {
    // no token or refresh
    update_option('cf-token', null);
    update_option('cf-refresh', null);

    $show_login = true;
} else {
    $brands = get_terms([
        'taxonomy' => 'brands',
        'hide_empty' => false,
    ]);
}
?>

<div class="wrap">
    <h2>TrunkBBI: Caterforce Akeneo PIM</h2>
    <h3>Version: 0.6.8</h3>
    <hr>
<?php
    if ($show_login) {
    // Shown if username/password empty
?>
    <p>Please enter your login details:</p>
    <form method="post" action="<?php echo admin_url('admin-post.php'); ?>" style="display:flex; flex-wrap:wrap; width: 50%;">
        <?php settings_fields('cf-settings'); ?>
        <div style="width:50%; display:flex; flex-direction:row; margin-bottom:10px;">
            <label for="cf-username" style="width:33%;">Username:</label>
            <input type="text" name="cf-username" id="cf-username" value="">
        </div>
        <div style="width:50%; display:flex; flex-direction:row; margin-bottom:10px;">
            <label for="cf-password" style="width:33%;">Password:</label>
            <input type="password" name="cf-password" id="cf-password" value="">
        </div>
        <div style="width:50%; display:flex; flex-direction:row; margin-bottom:10px;">
            <label for="cf-id" style="width:33%;">Client ID: </label>
            <input type="text" name="cf-id" id="cf-id"value="<?php echo get_option('cf-id'); ?>">
        </div>
        <div style="width:50%; display:flex; flex-direction:row; margin-bottom:10px;">
            <label for="cf-secret" style="width:33%;">Client Secret: </label>
            <input type="text" name="cf-secret" id="cf-secret" value="<?php echo get_option('cf-secret'); ?>">
        </div>
        <div style="width:100%; margin: 10px 0;">
            <input type="hidden" name="redirect" value="true">
            <input type="hidden" name="action" value="get_cf_token">
        <?php submit_button('Log In'); ?>
        </div>
    </form>
<?php
    } else {
    // Shown if all ready
?>
    <div style="display:flex; flex-direction:row; width:100%; justify-content:space-between;">
        <section style="display:flex; flex-direction:column; width:45%;">
            <h3>Access Tokens</h3>
            <div style="display:flex; flex-direction:row; width:100%; align-items:center;">
                <label for="cf-token" style="width:20%;">Access token</label>
                <input name="cf-token" style="width:80%;" id="cf-token" type="text"
                value="<?php echo get_option('cf-token'); ?>" disabled>
            </div>
            <div style="display:flex; flex-direction:row; width:100%; align-items:center;">
                <label for="cf-refresh" style="width:20%;">Refresh token</label>
                <input name="cf-refresh" style="width:80%;" id="cf-refresh" type="text"
                value="<?php echo get_option('cf-refresh'); ?>" disabled>
            </div>

            <div style="display:flex; flex-direction:row; width:100%; margin: 10px 0;">
                <form method="post" action="<?php echo admin_url('admin-post.php'); ?>" style="width:33%;">
                    <input type="hidden" name="redirect" value="true">
                    <input type="hidden" name="action" value="renew_cf_token">
                <?php submit_button('Renew Access Token', 'primary', 'submit', false); ?>
                </form>
                <form method="post" action="<?php echo admin_url('admin-post.php'); ?>" style="width:33%;">
                    <input type="hidden" name="redirect" value="true">
                    <input type="hidden" name="action" value="destroy_cf_token">
                <?php submit_button('Log Out', 'secondary', 'submit', false); ?>
                </form>
            </div>
        </section>

        <section style="width:45%;">
            <div style="display:flex; flex-direction:column; width:100%;">
                <h3>Manual Import</h3>
                <div style="display:flex; flex-direction:row; width:100%; margin-bottom: 20px;">
                    <form method="post" action="<?php echo admin_url('admin-post.php'); ?>" style="width:33%;">
                        <input type="hidden" name="action" value="schedule_import_categories">
                        <?php submit_button('Update Categories', 'primary', 'submit', false); ?>
                    </form>
                    <form method="post" action="<?php echo admin_url('admin-post.php'); ?>" style="width:33%;">
                        <input type="hidden" name="action" value="schedule_import_now">
                        <?php submit_button('Update Products', 'primary', 'submit', false); ?>
                    </form>
                    <form method="post" action="<?php echo admin_url('admin-post.php'); ?>" style="width:33%;">
                        <input type="hidden" name="action" value="schedule_import_brands">
                        <?php submit_button('Update Brands', 'primary', 'submit', false); ?>
                    </form>
                </div>
                <hr style="width:100%;">

                <h3>Daily Import Schedule</h3>
                <div style="width:100%; margin-bottom: 20px;">
                    <form method="post" action="<?php echo admin_url('admin-post.php'); ?>">
                        <?php settings_fields('cf-settings'); ?>
                        <input type="hidden" name="action" value="schedule_import">
                        <div style="display:flex; flex-direction:row; width:100%; align-items:center;">
                            <label for="cf-time" style="width:20%;">Daily run time:</label>
                            <div style="width:20%;">
                                <input type="time" id="cf-time" name="cf-time" value="<?php echo get_option('cf-schedule'); ?>" required>
                            </div>
                            <?php submit_button('Schedule Import', 'primary', '', false); ?>
                        </div>
                    </form>
                </div>
                <hr style="width:100%;">
                
                <h3>Imports In Queue</h3>
                <ul style="width:100%;">
<?php
    $crons = wp_get_ready_cron_jobs();
    $running = false;
    if (is_array($crons)) {
        foreach ($crons as $cron) {
            if(array_key_exists('cf_schedule_import_products', $cron)) {
                $running = true;
                echo '<li>Scheduled Product import</li>';
            }
            if(array_key_exists('cf_import_products', $cron)) {
                $running = true;
                echo '<li>Product import</li>';
            }
            if(array_key_exists('cf_import_brands', $cron)) {
                $running = true;
                echo '<li>Brand import</li>';
            }
            if(array_key_exists('cf_import_categories', $cron)) {
                $running = true;
                echo '<li>Category import</li>';
            }
        }
    }

    if(!$running) {
        echo "<li>No imports running</li>";
    }
?>
                </ul>
            </div>
        </section>
    </div>















    <hr>
    <section>
        <h3>Brands</h3>
        <form method="post" action="<?php echo admin_url('admin-post.php'); ?>">
    <?php settings_fields('cf-settings'); ?>
            <input type="hidden" name="action" value="set_brands">
            <div style="display:flex; flex-wrap: wrap;">               
<?php
    foreach ($brands as $brand) {
        echo '<div style="width: 25%;">';
        if (get_field('brand_used', 'brands_' . $brand->term_id)) {
            echo '  <input type="checkbox" id="brand-' . $brand->slug . '"
            name="cf-brand-' . $brand->term_id . '" checked>';
        } else {
            echo '  <input type="checkbox" id="brand-' . $brand->slug . '"
            name="cf-brand-' . $brand->term_id . '">';
        }
        echo '  <label for="brand-' . $brand->slug . '">' . $brand->name . '</label>';
        echo '</div>';
    }
?>
            </div>
            <div style="margin: 10px 0;">
                <?php submit_button('Update Displayed Brands', 'primary', '', false); ?>
            </div>
        </form>
    </section>


    <?php
}
?>
</div>
