<?php

    spl_autoload_register('tbbCfAutoloader');

    function tbbCfAutoloader($class) {
        $namespace = 'Tbbi\CF';

        if (strpos($class, $namespace) !== 0) {
            return;
        }

        $class = str_replace($namespace, '', $class);
        $class = str_replace('\\', DIRECTORY_SEPARATOR, $class) . '.php';

        $directory = plugin_dir_path( __FILE__ );
        $path = $directory . DIRECTORY_SEPARATOR . 'src' . $class;

        if (file_exists($path)) {
            require_once($path);
        }
    }
