<?php

    namespace Tbbi\CF;
    use WP_Query;

    class CaterforceImport
    {
        private const AKENEO_BASE_URL = 'https://caterforce.cloud.akeneo.com/';
        private const AKENEO_PRODUCTS = 'api/rest/v1/products';
        private $client_token;

        public function __construct()
        {
            $this->client_token = get_option('cf-token');

            add_action('admin_post_schedule_import_now', array($this, 'scheduleImportNow'));
            add_action('cf_import_products', [$this, 'getProducts']);
        }

        /**
         * Runs import task in 60 seconds
         *
         * @return void
         */
        public function scheduleImportNow()
        {
            $timestamp = strtotime(date("Y-m-d H:i:s", time() + 60)); // runs 1 min from now
            error_log("scheduleImportNow: ".$timestamp);
            wp_schedule_single_event($timestamp, 'cf_import_products', array(), true);
            wp_redirect(admin_url('options-general.php?page=akeneo-pim-menu.php'));
            die();
        }

        public function getProducts()
        {
            $args = array(
                'headers' => array(
                    'Authorization' => 'Bearer ' . $this->client_token,
                    'Content-Type' => 'application/json',
                )
            );
            $response = wp_remote_get($this::AKENEO_BASE_URL . $this::AKENEO_PRODUCTS, $args);
            if (!$response) {
                return false;
            }

            $data = json_decode(wp_remote_retrieve_body($response), true);

            if (!isset($data['_embedded']['items']) && is_array($data['_embedded']['items'])) {
                return false;
            }

            $this->parseProducts($data['_embedded']['items']);
        }

        private function parseProducts($data)
        {
            foreach ($data as $item) {
                if (isset($item['values']['cf_product_name'][0]['data'])) {
                    // Check if exists
                    $query = new WP_Query(array(
                        'numberposts' => 1,
                        'fields' => 'ids',
                        'post_type' => 'members-qas',
                        'meta_key' => 'product_sku',
                        'meta_value' => $item['identifier']
                    ));
                    if($query->have_posts()) {
                        while($query->have_posts()) {
                            $the_query->the_post();
                            $id = get_the_ID();
                        }
                    } else {
                        $id = $this->createProduct($item);
                    }
                    $this->updateProduct($id, $item);
                }
            }
        }

        private function createProduct($item)
        {
            $post = array(
                'post_type' => 'members-qas',
                'post_content' => '',
                'post_excerpt' => '',
                'post_status' => 'publish',
                'post_title' => $item['values']['cf_product_name'][0]['data'],
                'post_name' => '',
                'post_date' => $item['created'],
                'post_modified' => $item['updated'],
                'comment_status' => 'closed',
                'post_author' => 1
            );
            $id = wp_insert_post($post, true);
            if(is_wp_error($id)) {
                $errors = $id->get_error_messages();
                foreach ($errors as $error) {
                    error_log($error);
                }
                die();
            } else {
                return $id;
            }
        }

        private function updateProduct($id, $item)
        {
            // SKU
            update_field('product_sku', $item['identifier'], $id);

            // Overview
            update_field('product_overview', $item['values']['cf_product_description'][0]['data'], $id);
        }

        private function deleteProduct()
        {
            
        }
    }