<?php

    namespace Tbbi\CF;

    class CaterforceSettings
    {
        public function __construct()
        {
            add_action('init', [$this, 'createCpt']);
            add_action('acf/include_fields', [$this, 'createAcf']);

            add_action('admin_menu', function () {
                add_submenu_page(null, 'Akeneo PIM', 'Akeneo PIM', 'manage_options', 'akeneo-pim-menu', [$this, 'pluginAdminPage']);
            });

            add_filter("plugin_action_links_trunk-bbi-caterforce/trunk-bbi-caterforce.php", function($links) {
                $settings_link = '<a href="options-general.php?page=akeneo-pim-menu.php">Settings</a>';
                array_unshift($links, $settings_link);
                return $links;
            });
        }

        /**
         * Set up the admin page
         *
         * @return void
         */
        public function pluginAdminPage()
        {
			include(plugin_dir_path( __FILE__ ) . 'CaterforceAdmin.php');
        }

        /**
         * Create the CPT
         *
         * @return void
         */
        public function createCpt()
        {
            if (post_type_exists('members-qas')) {
                return;
            }

            $args = array(
                'label' => 'Member QAS',
                'labels' => array(

                ),
                'description' => 'Test',
                'public' => true,
                'show_ui' => true,
                'menu_icon' => 'dashicons-groups',
                'supports' => array(
                    'title',
                    'editor',
                    'revisions'
                )
            );

            register_post_type('members-qas', $args);
        }

        public function createAcf()
        {
            if (!function_exists('acf_add_local_field_group') ) {
                return;
            } else {
                acf_add_local_field_group(
                    array(
                        'key' => 'group_64e8c5ab1c207',
                        'title' => 'Products',
                        'fields' => array(
                            array(
                                'key' => 'field_64e8c84882353',
                                'label' => 'Product General',
                                'name' => '',
                                'aria-label' => '',
                                'type' => 'accordion',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'open' => 0,
                                'multi_expand' => 0,
                                'endpoint' => 0,
                            ),
                            array(
                                'key' => 'field_64e8c74801a67',
                                'label' => 'Product SKU',
                                'name' => 'product_sku',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '50',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_64e8c7fe8d0e7',
                                'label' => 'Product Overview',
                                'name' => 'product_overview',
                                'aria-label' => '',
                                'type' => 'wysiwyg',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '50',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'tabs' => 'visual',
                                'toolbar' => 'full',
                                'media_upload' => 0,
                                'delay' => 0,
                            ),
                            array(
                                'key' => 'field_64e8c774301c8',
                                'label' => 'Product Information',
                                'name' => '',
                                'aria-label' => '',
                                'type' => 'accordion',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'open' => 0,
                                'multi_expand' => 0,
                                'endpoint' => 0,
                            ),
                            array(
                                'key' => 'field_64e8c8607069b',
                                'label' => 'Packaging',
                                'name' => 'product_packaging',
                                'aria-label' => '',
                                'type' => 'textarea',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '50',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'rows' => 4,
                                'placeholder' => '',
                                'new_lines' => '',
                            ),
                            array(
                                'key' => 'field_64e8c8837069c',
                                'label' => 'Nutrition',
                                'name' => 'product_nutrition',
                                'aria-label' => '',
                                'type' => 'textarea',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '50',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'rows' => 4,
                                'placeholder' => '',
                                'new_lines' => '',
                            ),
                            array(
                                'key' => 'field_64e8c8947069d',
                                'label' => 'Dietary',
                                'name' => 'product_dietary',
                                'aria-label' => '',
                                'type' => 'textarea',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '50',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'rows' => 4,
                                'placeholder' => '',
                                'new_lines' => '',
                            ),
                            array(
                                'key' => 'field_64e8c8a57069e',
                                'label' => 'Allergens',
                                'name' => 'product_allergens',
                                'aria-label' => '',
                                'type' => 'textarea',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '50',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'rows' => 4,
                                'placeholder' => '',
                                'new_lines' => '',
                            ),
                            array(
                                'key' => 'field_64e8c8ad7069f',
                                'label' => 'Storage',
                                'name' => 'product_storage',
                                'aria-label' => '',
                                'type' => 'textarea',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '50',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'rows' => 4,
                                'placeholder' => '',
                                'new_lines' => '',
                            ),
                            array(
                                'key' => 'field_64e8c8b4706a0',
                                'label' => 'Directions',
                                'name' => 'product_directions',
                                'aria-label' => '',
                                'type' => 'textarea',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '50',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'rows' => 4,
                                'placeholder' => '',
                                'new_lines' => '',
                            ),
                            array(
                                'key' => 'field_64e8c78b301c9',
                                'label' => 'Product Images',
                                'name' => '',
                                'aria-label' => '',
                                'type' => 'accordion',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'open' => 0,
                                'multi_expand' => 0,
                                'endpoint' => 0,
                            ),
                            array(
                                'key' => 'field_64e8c78e301ca',
                                'label' => 'Product Downloads',
                                'name' => '',
                                'aria-label' => '',
                                'type' => 'accordion',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'open' => 0,
                                'multi_expand' => 0,
                                'endpoint' => 0,
                            ),
                            array(
                                'key' => 'field_64e8c8c0706a1',
                                'label' => 'Downloads',
                                'name' => 'product_downloads',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'table',
                                'pagination' => 0,
                                'min' => 0,
                                'max' => 0,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                            array(
                                'key' => 'field_64e8c8da706a2',
                                'label' => 'Title',
                                'name' => 'title',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '66',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_64e8c8c0706a1',
                            ),
                            array(
                                'key' => 'field_64e8c8ee706a3',
                                'label' => 'File',
                                'name' => 'file',
                                'aria-label' => '',
                                'type' => 'file',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '33',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'url',
                                'library' => 'all',
                                'min_size' => '',
                                'max_size' => '',
                                'mime_types' => '',
                                'parent_repeater' => 'field_64e8c8c0706a1',
                            ),
                     ),
                    ),
                    array(
                        'key' => 'field_64e8c7ce00365',
                        'label' => '',
                        'name' => '',
                        'aria-label' => '',
                        'type' => 'accordion',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'open' => 0,
                        'multi_expand' => 0,
                        'endpoint' => 1,
                    ),
                ),
                    'location' => array(
                        array(
                            array(
                                'param' => 'post_type',
                                'operator' => '==',
                                'value' => 'members-qas',
                            ),
                        ),
                    ),
                    'menu_order' => 0,
                    'position' => 'normal',
                    'style' => 'default',
                    'label_placement' => 'top',
                    'instruction_placement' => 'label',
                    'hide_on_screen' => array(
                        0 => 'the_content',
                        1 => 'excerpt',
                        2 => 'discussion',
                        3 => 'comments',
                        4 => 'revisions',
                        5 => 'slug',
                        6 => 'author',
                        7 => 'format',
                        8 => 'page_attributes',
                        9 => 'featured_image',
                        10 => 'categories',
                        11 => 'tags',
                        12 => 'send-trackbacks',
                    ),
                    'active' => true,
                    'description' => '',
                    'show_in_rest' => 0,
                    'modified' => 1693317418,
                    )
                );
            }
        }
    }