<?php

namespace Tbbi\CF;

class CaterforceSettings
{
    public function __construct()
    {
        add_action('init', [$this, 'createCpt']);
        add_action('init', [$this, 'createTax']);

        add_action('acf/update_field_group', [$this, 'createAcf'], 1, 1);
        add_filter('acf/settings/load_json', [$this, 'loadAcf'],1);
        add_action('add_meta_boxes' , [$this, 'removeCategoryMeta'], 50);
        add_action('add_meta_boxes', [$this, 'addMetaToSingle']);
        add_action('admin_head', [$this ,'styleAdmin']);
        add_filter('user_has_cap', [$this, 'removeProductRowLinks'], 10, 3);
        add_filter('post_row_actions', [$this, 'removeProductViewLinks'], 10, 1);
        add_filter('manage_qas_posts_columns', [$this ,'createCptColumns'], 5);
        add_action('manage_qas_posts_custom_column', [$this ,'fillCptColumns'], 5, 2);
        add_action('manage_edit-qas_sortable_columns', [$this ,'setSortCptColumns']);
        add_filter('bulk_actions-edit-qas', [$this, 'removeBulkActions']);
        add_action('pre_get_posts', [$this, 'sortProductColumns']);
        add_action('admin_head', [$this ,'styleColumns']);
        add_action('wp_before_admin_bar_render', [$this, 'removeFromAdminBar']);
        add_action('admin_menu', [$this, 'editCptMenu']);
        add_filter('acf/load_field', [$this, 'readOnlyAcf']);
    }

    public function pluginAdminPage()
    {
        include(plugin_dir_path(__FILE__) . 'CaterforceAdmin.php');
    }

    public function createCpt()
    {
        if (post_type_exists('qas')) {
            return;
        }

        $args = array(
            'label' => 'Own Brand Products',
            'labels' => array(),
            'public' => true,
            'show_ui' => true,
            'menu_icon' => 'dashicons-carrot',
            'supports' => array(
                'title',
                'editor',
                'revisions'
            )
        );

        register_post_type('qas', $args);
    }

    public function removeBulkActions($actions)
    {
        return array();
    }

    public function createCptColumns($columns)
    {
        unset($columns['cb']);

        $new = array();
        foreach ($columns as $key => $value) {
            if ($key == 'date') {
                $new['identifier'] = 'Identifier';
                $new['csbc'] = 'CSBC';
                $new['brand'] = 'Brand';
            }
            if ($key == 'title') {
                $new['image'] = 'Image';
            }
            $new[$key] = $value;
        }
        return $new;
    }

    public function fillCptColumns($name, $id)
    {
        global $post;
        if ($name === 'image') {
            if (have_rows('product_images', $id)) {
                while (have_rows('product_images', $id)) {
                    the_row();
                    $image = get_sub_field('image');
                    if (is_array($image)) {
                        echo '<img src="' . $image['sizes']['thumbnail'] . '" width="50px" height="50px">';
                        break;
                    }
                }
            }
        }

        if ($name === 'identifier') {
            echo get_field('product_identifier', $id);
        }

        if ($name === 'csbc') {
            echo get_field('product_csbc', $id);
        }

        if ($name === 'brand') {
            $brands = get_the_terms($id, 'brands');
            if ($brands) {
                foreach ($brands as $brand) {
                    echo $brand->name;
                }
            }
        }
    }

    public function setSortCptColumns($columns)
    {
        $columns['identifier'] = 'product_identifier';
        $columns['csbc'] = 'product_csbc';

        return $columns;
    }

    public function sortProductColumns($query) {
        if (!is_admin() || !$query->is_main_query()) {
            return $query;
        }

        if ($query->post_type == 'qas') {
            if ($query->get('orderby') == 'product_identifier') {
                $query->set('orderby', 'meta_value');
                $query->set('meta_key', 'product_identifier');
            }

            if ($query->get('orderby') == 'product_csbc') {
                $query->set('orderby', 'meta_value');
                $query->set('meta_key', 'product_csbc');
            }
        }

        return $query;
    }

    public function styleColumns()
    {
        $screen = get_current_screen();
        if ($screen->id == 'edit-qas') {
            echo '<style>.column-image {width: 100px;} .column-image img, { width:80px; height: auto; }</style>';
        }
    }

    public function createTax()
    {
        register_taxonomy('allergens', 'qas', array(
            'hierarchical' => false,
            'public' => false,
            'labels' => array(
                'name' => 'Allergens',
                'singular_name' => 'Allergen',
                'search_items' => 'Search Allergens',
                'all_items' => 'All Allergens',
                'parent_item' => 'Parent Allergen',
                'parent_item_colon' => 'Parent Allergen:',
                'edit_item' => 'Edit Allergen',
                'update_item' => 'Update Allerges',
                'add_new_item' => 'Add new allergen',
                'new_item_name' => 'New allergen name',
                'menu_name' => 'Allergens'
            ),
            'rewrite' => array(
                'slug' => 'allergens',
                'with_front' => false,
                'hierarchical' => false
            )
        ));

        register_taxonomy('allergens-may-contain', 'qas', array(
            'hierarchical' => false,
            'public' => false,
            'labels' => array(
                'name' => 'Allergens (May Contain)',
                'singular_name' => 'Allergen (May Contain)',
                'search_items' => 'Search Allergens (May Contain)',
                'all_items' => 'All Allergens (May Contain)',
                'parent_item' => 'Parent Allergen (May Contain)',
                'parent_item_colon' => 'Parent Allergen (May Contain):',
                'edit_item' => 'Edit Allergen (May Contain)',
                'update_item' => 'Update Allergens (May Contain)',
                'add_new_item' => 'Add new allergen (May Contain)',
                'new_item_name' => 'New allergen name (May Contain)',
                'menu_name' => 'Allergens'
            ),
            'rewrite' => array(
                'slug' => 'allergens-may-contain',
                'with_front' => false,
                'hierarchical' => false
            )
        ));

        register_taxonomy('diet', 'qas', array(
            'hierarchical' => false,
            'public' => false,
            'labels' => array(
                'name' => 'Diet',
                'singular_name' => 'Diet',
                'search_items' => 'Search Diets',
                'all_items' => 'All Diets',
                'parent_item' => 'Parent Diet',
                'parent_item_colon' => 'Parent Diet:',
                'edit_item' => 'Edit Diet',
                'update_item' => 'Update Diet',
                'add_new_item' => 'Add new diet',
                'new_item_name' => 'New diet name',
                'menu_name' => 'Diet'
            ),
            'rewrite' => array(
                'slug' => 'diet',
                'with_front' => false,
                'hierarchical' => false
            )
        ));

        register_taxonomy('product-category', 'qas', array(
            'hierarchical' => true,
            'public' => true,
            'labels' => array(
                'name' => 'Categories',
                'singular_name' => 'Category',
                'search_items' => 'Search Categories',
                'all_items' => 'All Categories',
                'parent_item' => 'Parent Category',
                'parent_item_colon' => 'Parent Category:',
                'edit_item' => 'Edit Category',
                'update_item' => 'Update Category',
                'add_new_item' => 'Add new category',
                'new_item_name' => 'New category name',
                'menu_name' => 'Categories'
            ),
            'rewrite' => array(
                'slug' => 'categories',
                'with_front' => true,
                'hierarchical' => false
            )
        ));

        register_taxonomy('brands', 'qas', array(
            'hierarchical' => false,
            'public' => true,
            'labels' => array(
                'name' => 'Brands',
                'singular_name' => 'Brands',
                'search_items' => 'Search Brands',
                'all_items' => 'All Brands',
                'parent_item' => 'Parent Brand',
                'parent_item_colon' => 'Parent Brand:',
                'edit_item' => 'Edit Brand',
                'update_item' => 'Update Brand',
                'add_new_item' => 'Add new brand',
                'new_item_name' => 'New brand name',
                'menu_name' => 'Brands'
            ),
            'rewrite' => array(
                'slug' => 'brands',
                'with_front' => true,
                'hierarchical' => false
            )
        ));
    }

    public function createAcf($group)
    {
        $groups = array(
            'group_64e8c5ab1c207',
            'group_64f9a9cc60d18'
        );

        if (in_array($group['key'], $groups)) {
            add_filter('acf/settings/save_json', function() {
                return dirname(__FILE__) . '/acf-json';
            });
        }
    }

    public function loadAcf($paths)
    {
        $paths[] = dirname(__FILE__) . '/acf-json';
        return $paths;
    }

    public function readOnlyAcf($field)
    {
        $fields = array(
            'product_identifier','product_gtin','product_csbc','product_supplier','product_supplier_code',
            'erudus_id','erudus_status','country_of_origin','case_size','product_overview','product_overview_2',
            'product_storage', 'product_directions','product_ingredients', 'product_taxonomies', 'allergens',
            'allergens_may_contain', 'category', 'brand', 'kj_per_100g', 'fat_per_100g', 'fat_saturates_per_100g',
            'kcal_per_100g', 'salt_per_100g', 'fibre_per_100g', 'carbs_per_100g', 'carbs_that_sugars_per_100g', 'protein_per_100g',
            'product_images'
        );
        if (in_array($field['name'], $fields)) {
            $field['readonly'] = true;
            $field['disabled'] = true;
        }

        return $field;
    }

    public function removeCategoryMeta()
    {
        // remove_meta_box('tagsdiv-product-category', 'qas' ,'side');
        remove_meta_box('tagsdiv-brands', 'qas', 'side');
    }

    public function addMetaToSingle() {
        add_meta_box(
            'pim-single',
            'Product Information',
            [$this, 'metaPimCallback'],
            'qas',
            'side'
        );
    }

    public function metaPimCallback($post)
    {
        $url = admin_url('admin-ajax.php');
        $hash = wp_create_nonce($post->ID.'nfjklgsdnjklvnjklvsbnilv');
        $identifier = get_field('product_identifier', $post->ID);

        echo '<div><h3>PIM Options</h3>';
        echo '<button type="button" class="button button-secondaryprimary js-pim-update" name="Update" value="Update"';
        echo 'data-hash="'.$hash.'" data-postid="'.$post->ID.'" data-productid="'.$identifier.'"';
        echo '>Update From PIM</button>';
        echo '<script>jQuery(function(){jQuery(".js-pim-update").on("click",function(t){t.preventDefault();var a={action:"cf_import_single",hash:jQuery(t.target).data("hash"),product_id:jQuery(t.target).data("productid"),post_id:jQuery(t.target).data("postid")};jQuery.post(ajaxurl,a,function(t){alert("Update scheduled. Please check back in 2 minutes")})})});</script>';
        echo '</div>';

        echo '<div><h3>Permalinks</h3>';
        echo '<a href="/products/'.$post->post_name.'/" target="_blank">Brochure</a><br>';
        echo '<a href="/members/own-brand-assets/qas-sheets/'.$post->post_name.'/" target="_blank">Members</a><br>';
        echo '</div>';
    }

    public function styleAdmin()
    {
        echo '<style>#preview-action, #minor-publishing-actions, #misc-publishing-actions, #yoast-seo-publishbox-section, .post-type-qas #edit-slug-box, .post-type-qas h1.wp-heading-inline, .post-type-qas a.page-title-action {display:none;}</style>';
        echo '<script>jQuery(function() {jQuery(".post-type-qas #titlewrap input").prop("disabled", true);});</script>';
    }

    public function removeProductViewLinks($actions) {
        if (get_post_type() === 'qas') {
            unset($actions['view']);
            unset($actions['inline hide-if-no-js']);
        }
        return $actions;
    }

    public function removeProductRowLinks($allcaps, $caps, $args)
    {
        if (isset($args[0]) && isset($args[2])) {
            $post = get_post($args[2]);
            if($args[0] == 'delete_post' && $post->post_type == 'qas') {
                $allcaps[$caps[0]] = false;
            }
        }

        return $allcaps;
    }

    public function removeFromAdminBar()
    {
        global $wp_admin_bar;
        global $post;

        $wp_admin_bar->remove_menu('new-qas');

        if(is_object($post) && isset($post->post_type)) {
            if($post->post_type == 'qas') {
                $wp_admin_bar->remove_menu('view');
            }
        }
            
    }

    public function editCptMenu()
    {
        remove_submenu_page(
            'edit.php?post_type=qas',
            'post-new.php?post_type=qas'
        );

        remove_submenu_page(
            'edit.php?post_type=qas',
            'edit-tags.php?taxonomy=brands&amp;post_type=qas'
        );

        remove_submenu_page(
            'edit.php?post_type=qas',
            'edit-tags.php?taxonomy=product-category&amp;post_type=qas'
        );

        add_submenu_page(
            'edit.php?post_type=qas',
            'Akeneo PIM Importer',
            'Akeneo PIM Importer',
            'manage_options',
            'akeneo-pim-menu',
            [$this, 'pluginAdminPage']
        );
    }
}
