<?php

namespace Tbbi\CF;

class CaterforceSettings
{
    public function __construct()
    {
        add_action('init', [$this, 'createCpt']);
        add_action('init', [$this, 'createTax']);

        add_action('acf/update_field_group', [$this, 'createAcf'], 1, 1);
        add_filter('acf/settings/load_json', [$this, 'loadAcf'],1);

        // add_action('acf/include_fields', [$this, 'createAcf']);
        add_action('add_meta_boxes' , [$this, 'removeCategoryMeta'], 50 );

        add_action('admin_menu', function () {
            add_submenu_page(
                'options-general.php',
                'Akeneo PIM',
                'Akeneo PIM',
                'manage_options',
                'akeneo-pim-menu',
                [$this, 'pluginAdminPage']
            );
        });

        // add_filter("plugin_action_links_trunk-bbi-caterforce/trunk-bbi-caterforce.php", function ($links) {
        //     $settings_link = '<a href="options-general.php?page=akeneo-pim-menu.php">Settings</a>';
        //     array_unshift($links, $settings_link);
        //     return $links;
        // });

        add_filter('manage_qas_posts_columns', [$this ,'createCptColumns'], 5);
        add_action('manage_qas_posts_custom_column', [$this ,'fillCptColumns'], 5, 2);
        add_action('admin_head', [$this ,'styleColumns']);
    }

    /**
     * Set up the admin page
     *
     * @return void
     */
    public function pluginAdminPage()
    {
        include(plugin_dir_path(__FILE__) . 'CaterforceAdmin.php');
    }

    /**
     * Create the CPT
     *
     * @return void
     */
    public function createCpt()
    {
        if (post_type_exists('qas')) {
            return;
        }

        $args = array(
            'label' => 'QAS',
            'labels' => array(),
            'public' => true,
            'show_ui' => true,
            'menu_icon' => 'dashicons-carrot',
            'supports' => array(
                'title',
                'editor',
                'revisions'
            )
        );

        register_post_type('qas', $args);
    }

    public function createCptColumns($columns)
    {
        $new = array();
        foreach ($columns as $key => $value) {
            if ($key == 'date') {
                $new['identifier'] = 'Identifier';
                $new['brand'] = 'Brand';
            }
            if ($key == 'title') {
                $new['image'] = 'Image';
            }
            $new[$key] = $value;
        }
        return $new;
    }

    public function fillCptColumns($name, $id)
    {
        global $post;
        if ($name === 'image') {
            if (have_rows('product_images', $id)) {
                while (have_rows('product_images', $id)) {
                    the_row();
                    $image = get_sub_field('image');
                    if (is_array($image)) {
                        echo '<img src="' . $image['sizes']['thumbnail'] . '" width="50px" height="50px">';
                        break;
                    }
                }
            }
        }

        if ($name === 'identifier') {
            echo get_field('product_identifier', $id);
        }

        if ($name === 'brand') {
            $brands = get_the_terms($id, 'brands');
            if ($brands) {
                foreach ($brands as $brand) {
                    echo $brand->name;
                }
            }
        }
    }

    public function styleColumns()
    {
        $screen = get_current_screen();
        if ($screen->id == 'edit-qas') {
            echo '<style>.column-image {width: 100px;} .column-image img, { width:80px; height: auto; }</style>';
        }
    }

    public function createTax()
    {
        register_taxonomy('allergens', 'qas', array(
            'hierarchical' => false,
            'public' => false,
            'labels' => array(
                'name' => 'Allergens',
                'singular_name' => 'Allergen',
                'search_items' => 'Search Allergens',
                'all_items' => 'All Allergens',
                'parent_item' => 'Parent Allergen',
                'parent_item_colon' => 'Parent Allergen:',
                'edit_item' => 'Edit Allergen',
                'update_item' => 'Update Allerges',
                'add_new_item' => 'Add new allergen',
                'new_item_name' => 'New allergen name',
                'menu_name' => 'Allergens'
            ),
            'rewrite' => array(
                'slug' => 'allergens',
                'with_front' => false,
                'hierarchical' => false
            )
        ));

        register_taxonomy('allergens-may-contain', 'qas', array(
            'hierarchical' => false,
            'public' => false,
            'labels' => array(
                'name' => 'Allergens (May Contain)',
                'singular_name' => 'Allergen (May Contain)',
                'search_items' => 'Search Allergens (May Contain)',
                'all_items' => 'All Allergens (May Contain)',
                'parent_item' => 'Parent Allergen (May Contain)',
                'parent_item_colon' => 'Parent Allergen (May Contain):',
                'edit_item' => 'Edit Allergen (May Contain)',
                'update_item' => 'Update Allergens (May Contain)',
                'add_new_item' => 'Add new allergen (May Contain)',
                'new_item_name' => 'New allergen name (May Contain)',
                'menu_name' => 'Allergens'
            ),
            'rewrite' => array(
                'slug' => 'allergens-may-contain',
                'with_front' => false,
                'hierarchical' => false
            )
        ));

        register_taxonomy('diet', 'qas', array(
            'hierarchical' => false,
            'public' => false,
            'labels' => array(
                'name' => 'Diet',
                'singular_name' => 'Diet',
                'search_items' => 'Search Diets',
                'all_items' => 'All Diets',
                'parent_item' => 'Parent Diet',
                'parent_item_colon' => 'Parent Diet:',
                'edit_item' => 'Edit Diet',
                'update_item' => 'Update Diet',
                'add_new_item' => 'Add new diet',
                'new_item_name' => 'New diet name',
                'menu_name' => 'Diet'
            ),
            'rewrite' => array(
                'slug' => 'diet',
                'with_front' => false,
                'hierarchical' => false
            )
        ));

        register_taxonomy('product-category', 'qas', array(
            'hierarchical' => false,
            'public' => true,
            'labels' => array(
                'name' => 'Categories',
                'singular_name' => 'Category',
                'search_items' => 'Search Categories',
                'all_items' => 'All Categories',
                'parent_item' => 'Parent Category',
                'parent_item_colon' => 'Parent Category:',
                'edit_item' => 'Edit Category',
                'update_item' => 'Update Category',
                'add_new_item' => 'Add new category',
                'new_item_name' => 'New category name',
                'menu_name' => 'Categories'
            ),
            'rewrite' => array(
                'slug' => 'categories',
                'with_front' => true,
                'hierarchical' => false
            )
        ));

        register_taxonomy('brands', 'qas', array(
            'hierarchical' => false,
            'public' => true,
            'labels' => array(
                'name' => 'Brands',
                'singular_name' => 'Brands',
                'search_items' => 'Search Brands',
                'all_items' => 'All Brands',
                'parent_item' => 'Parent Brand',
                'parent_item_colon' => 'Parent Brand:',
                'edit_item' => 'Edit Brand',
                'update_item' => 'Update Brand',
                'add_new_item' => 'Add new brand',
                'new_item_name' => 'New brand name',
                'menu_name' => 'Brands'
            ),
            'rewrite' => array(
                'slug' => 'brands',
                'with_front' => true,
                'hierarchical' => false
            )
        ));
    }

    public function createAcf($group)
    {
        $groups = array(
            'group_64e8c5ab1c207',
            'group_64f9a9cc60d18'
        );

        if (in_array($group['key'], $groups)) {
            add_filter('acf/settings/save_json', function() {
                return dirname(__FILE__) . '/acf-json';
            });
        }
    }

    public function loadAcf($paths)
    {
        $paths[] = dirname(__FILE__) . '/acf-json';
        return $paths;
    }

    /**
     * Remove the category boxes from the admin
     *
     * @return void
     */
    public function removeCategoryMeta()
    {
        remove_meta_box('tagsdiv-product-category', 'qas' ,'side');
        remove_meta_box('tagsdiv-brands', 'qas', 'side');
    }
}
