<?php

/*
    Plugin Name: Caterforce Akeneo PIM
    Plugin URI: https://trunkbbi.com
    Author: TrunkBBI
    Author URI: https://trunkbbi.com
    Description: TrunkBBI custom plugin to fetch data from Akeneo PIM API
    Version: 0.5.0
*/

namespace Tbbi\CF;

if (!defined('ABSPATH')) {
    die();
}

if (!class_exists('CaterforceAkeneo')) {
    class CaterforceAkeneo
    {
        public function __construct()
        {
            require_once plugin_dir_path(__FILE__) . '/autoloader.php';

            register_activation_hook(__FILE__, [$this, 'activatePlugin']);
            register_deactivation_hook(__FILE__, [$this, 'deactivatePlugin']);

            $this->adminSetup();
        }

        /**
         * Fired on activation of the plugin
         *
         * @return void
         */
        public function activatePlugin()
        {
            // Check For ACF
            if (!class_exists('ACF')) {
                deactivate_plugins(plugin_basename(__FILE__));
                wp_die(__('ACF Pro is required for this plugin to work', 'tbbi-caterforce'));
            }

            add_action('admin_init', function () {
                register_setting('cf-settings', 'cf-id');
                register_setting('cf-settings', 'cf-secret');
                register_setting('cf-settings', 'cf-token');
                register_setting('cf-settings', 'cf-refresh');
                register_setting('cf-settings', 'cf-schedule');
            });
        }

        /**
         * Fired on deactivation of the plugin
         *
         * @return void
         */
        public function deactivatePlugin()
        {
            delete_option('cf-id');
            delete_option('cf-token');
            delete_option('cf-refresh');
            delete_option('cf-secret');
            delete_option('cf-schedule');
            wp_clear_scheduled_hook('cf_schedule_import_products');
        }

        /**
         * Main entry
         *
         * @return void
         */
        private function adminSetup()
        {
            new CaterforceAuth();
            new CaterforceSettings();
        }
    }
}

new CaterforceAkeneo();
