document.addEventListener("DOMContentLoaded", function () {
    const form = document.querySelector('.js-trunkbbi-form');
    const formTag = document.querySelector('form.fusion-form');
    const uid = Date.now().toString(36) + Math.floor(Math.pow(10, 12) + Math.random() * 9*Math.pow(10, 12)).toString(36);
    const utmData = localStorage.getItem('utm_data');

    const getIntroducer = () => {
        const introducer = document.getElementById('Introducer').getElementsByTagName('input')[0];
        const fieldId = 'fpc_introducer';
        const fieldValue = introducer.value;

        handleInputChange(fieldId, fieldValue, uid);
    };

    if (form) {
        // ADD UTM DATA TO DATABASE
        if (utmData) {
            handleInputChange('fpc_utm_data', utmData, uid);
        }

        const fields = form.querySelectorAll('.fusion-form-field');

        fields.forEach((field) => {
            let fieldId = null;

            field.classList.forEach((className) => {
                if (className.startsWith('fpc_')) {
                    fieldId = className;
                }

                if (fieldId) {
                    let inputs = field.querySelectorAll('input, select');
                    
                    inputs.forEach((input) => {
                        input.addEventListener('blur', (event) => {
                            let fieldValue = event.target.value;

                            // ADDITIONAL VALIDATION REQUIRED FOR CHECKBOX & RADIO FIELD TYPES TO RETURN CORRECT ID & VALUE
                            if (fieldId.includes('fpc_marketing_consent')) {
                                fieldId = `fpc_marketing_consent_${fieldValue}`;
                                fieldValue = event.target.checked;
                            } else if (fieldId === 'fpc_partial_completion_consent') {
                                fieldValue = !event.target.checked;
                            } else if (fieldId === 'fpc_privacy_notice') {
                                let consentGiven = false;

                                if (event.target.value === 'yes') {
                                    consentGiven = event.target.checked; 
                                }

                                fieldValue = consentGiven;
                            } else if (fieldId === 'fpc_residence') {
                                getIntroducer();
                            }
            
                            handleInputChange(fieldId, fieldValue, uid);
                        });
                    });
                }
            });
        });

        formTag.addEventListener('submit', () => {
            let fieldId = 'fpc_form_submitted';
            let fieldValue = true;

            handleInputChange(fieldId, fieldValue, uid);
        })

        function handleInputChange(fieldId, fieldValue, uid) {
            const requestData = {
                action: "update_field",
                field_id: fieldId,
                field_value: fieldValue,
                uid: uid
            };

            fetch(ajaxurl, {
                method:"post",
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: new URLSearchParams( requestData ).toString(),
            }).catch(error => {
                console.error(error);
            });
        }
    }
});