<?php
/**
 * Plugin Name:     TrunkBBI Intasure Partial Completion
 * Plugin URI:      https://trunkbbi.com
 * Description:     
 * Author:          M.Bolsover, R.Jones-Smith
 * Author URI:      https://trunkbbi.com
 * Text Domain:     trunkbbi
 * Domain Path:     /languages
 * Version:         0.0.2
 *
 * @package         Trunk_Bbi_Intasure
 */

if (!defined('ABSPATH')) {
    die();
}

if (!class_exists('TrunkBBI')) {

    class TrunkBBI
    {
        public function __construct()
        {
            $this->initPlugin();
        }

        private function initPlugin()
        {
            register_activation_hook(__FILE__, [$this, 'activatePlugin']);
            register_deactivation_hook(__FILE__, [$this, 'deactivatePlugin']);

            add_action('wp_enqueue_scripts', [$this, 'enqueuePartialCompletionScript']);
            add_action('wp_head', [$this, 'setUrl']);
            add_action('wp_ajax_update_field', [$this, 'ajaxUpdateField']);
            add_action('wp_ajax_nopriv_update_field', [$this, 'ajaxUpdateField']);
            add_action('form_partial_completion_event', [$this, 'handle_daily_event']);

            $this->scheduleEvent();
        }

        public function activatePlugin()
        {
            $this->createDatabaseTables();
        }

        public function deactivatePlugin()
        {
            $this->dropDatabaseTables();
            $this->clearScheduledEvents();
        }

        public function createDatabaseTables()
        {
            global $wpdb;

            $table_name = $wpdb->prefix . 'partial_form_completions';

            $charset_collate = $wpdb->get_charset_collate();

            $sql = "CREATE TABLE $table_name (
                id mediumint(9) NOT NULL AUTO_INCREMENT,
                time datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
                uid varchar(100),
                fpc_introducer varchar(30),
                fpc_utm_data text,
                fpc_first_name tinytext,
                fpc_last_name tinytext,
                fpc_telephone varchar(30),
                fpc_email tinytext,
                fpc_residence tinytext,
                fpc_house_number varchar(30),
                fpc_street_name tinytext,
                fpc_town_or_city tinytext,
                fpc_county tinytext,
                fpc_postcode varchar(10),
                fpc_marketing_consent_email varchar(10) DEFAULT 'false',
                fpc_marketing_consent_sms varchar(10) DEFAULT 'false',
                fpc_marketing_consent_phone varchar(10) DEFAULT 'false',
                fpc_marketing_consent_post varchar(10) DEFAULT 'false',
                fpc_partial_completion_consent varchar(10) DEFAULT 'true',
                fpc_country tinytext,
                fpc_year_built varchar(30),
                fpc_property_type tinytext,
                fpc_property_name varchar(30),
                fpc_property_postcode varchar(10),
                fpc_bedrooms varchar(20),
                fpc_contents_cover varchar(20),
                fpc_start_date date,
                fpc_privacy_notice varchar(10) DEFAULT 'false',
                fpc_form_submitted varchar(10) DEFAULT 'false',
                PRIMARY KEY  (id)
            ) $charset_collate;";

            require_once ABSPATH . 'wp-admin/includes/upgrade.php';

            dbDelta( $sql );
        }

        public function dropDatabaseTables()
        {
            // UNCOMMENT TO DROP DATABASE TABLE ON PLUGIN DEACTIVATION
            // global $wpdb;
            // $table_name = $wpdb->prefix . 'partial_form_completions';
            // $wpdb->query( "DROP TABLE IF EXISTS $table_name" );
        }

        public function enqueuePartialCompletionScript()
        {   
            wp_enqueue_script( 'form-partial-completions', plugins_url('app/js/form-partial-completions.js', __FILE__ ), array(), '1.0.0', array() );
        }

        public function setUrl()
        {
            echo '<script type="text/javascript">var ajaxurl = "' . admin_url('admin-ajax.php') . '";</script>';
        }

        public function ajaxUpdateField()
        {
            if (isset($_POST['field_id'])) {
                $field_id = $_POST['field_id'];
                $field_value = $_POST['field_value'];
            }

            if (isset($_POST['uid'])) {
                global $wpdb;

                $uid = $_POST['uid'];
                $table_name = $wpdb->prefix . 'partial_form_completions';
                $sql = $wpdb->prepare("SELECT EXISTS (SELECT 1 FROM $table_name WHERE uid = %s) AS uid_exists", $uid);
                $uid_exists = $wpdb->get_var($sql);

                if (!$uid_exists) {
                    $data = array(
                        $field_id => $field_value,
                        'uid' => $uid,
                        'time' => current_time('mysql')
                    );

                    $wpdb->insert($table_name, $data);
                } else {
                    if ($field_id === 'fpc_introducer') {
                        $introducer_id = $field_value;
                        $field_value = $this->getIntroducerName($introducer_id);
                    }

                    $data = array(
                        $field_id => $field_value
                    );

                    $where = array(
                        'uid' => $uid
                    );

                    $wpdb->update($table_name, $data, $where);
                }
            }

            die();
        }

        function scheduleEvent()
        {
            if (!wp_next_scheduled('form_partial_completion_event')) {
                wp_schedule_event(time(), 'hourly', 'form_partial_completion_event');
            }
        }

        function handle_daily_event() {
            global $wpdb;

            $isProd = parse_url(get_site_url(), PHP_URL_HOST) == 'intasure.com';

            $table_name = $wpdb->prefix . 'partial_form_completions';
            $today = current_time('Y-m-d');

            // GET UTM DATA
            $utm_data = $wpdb->get_results(
                $wpdb->prepare("SELECT time, fpc_utm_data, fpc_form_submitted FROM $table_name WHERE fpc_utm_data IS NOT NULL", null),
                ARRAY_A
            );

            // GET ALL TODAYS ENTRIES
            $results = $wpdb->get_results(
                $wpdb->prepare("SELECT * FROM $table_name", null),
                ARRAY_A
            );

            // DELETE ENTRIES WHERE PARTIAL COMPLETION CONSENT IS NOT GIVEN AND WHERE THE FORM HAS BEEN SUCCESSFULLY SUBMITTED
            if (!empty($results)) {
                foreach ($results as $row) {
                    if ($row['fpc_partial_completion_consent'] === 'false' || $row['fpc_form_submitted'] === 'true' || ($row['fpc_marketing_consent_email'] === 'false' && $row['fpc_marketing_consent_phone'] === 'false')) {
                        $wpdb->delete(
                            $table_name,
                            array('id' => $row['id']),
                            array('%d')
                        );
                    }
                }
            }

            // GET ALL TODAYS ENTRIES NOW FILTERED FOR PARTIAL COMPLETION APPROVAL AND FORM NOT SUBMITTED
            $results = $wpdb->get_results(
                $wpdb->prepare("SELECT * FROM $table_name", null),
                ARRAY_A
            );

            $no_results = empty($results);

            if (!$no_results) {
                // REMOVE UID FROM TABLE DATA
                for ($i = 0; $i < count($results); $i++) {
                    if (isset($results[$i]['uid'])) {
                        unset($results[$i]['uid']);
                    }
                }

                // SEND DATA TO ACTURIS
                // foreach ($results as $result) {
                //     $fields = array(
                //         'fpc_introducer' => 'Introducer',
                //         'fpc_first_name' => 'FirstName',
                //         'fpc_last_name' => 'LastName',
                //         'fpc_telephone' => 'Telephone',
                //         'fpc_email' => 'Email',
                //         'fpc_residence' => 'Residence',
                //         'fpc_house_number' => 'house_number',
                //         'fpc_street_name' => 'street_name',
                //         'fpc_town_or_city' => 'town_or_city',
                //         'fpc_county' => 'county',
                //         'fpc_postcode' => 'postcode',
                //         'fpc_marketing_consent_email' => 'marketing_consent_email',
                //         'fpc_marketing_consent_sms' => 'marketing_consent_sms',
                //         'fpc_marketing_consent_phone' => 'marketing_consent_phone',
                //         'fpc_marketing_consent_post' => 'marketing_consent_post',
                //         'fpc_partial_completion_consent' => 'partial_completion_consent',
                //         'fpc_country' => 'country',
                //         'fpc_year_built' => 'year_built',
                //         'fpc_property_type' => 'property_type',
                //         'fpc_property_name' => 'property_name',
                //         'fpc_property_postcode' => 'TaskDescription',
                //         'fpc_bedrooms' => 'bedrooms',
                //         'fpc_contents_cover' => 'contents_cover',
                //         'fpc_start_date' => 'start_date',
                //         'fpc_privacy_notice' => 'consent'
                //     );

                //     $body = array(
                //         'ProductType' => 'Holiday Home Insurance'
                //     );

                //     foreach ($result as $key => $value) {
                //         if(isset($fields[$key])) {
                //             $body[$fields[$key]] = $value;
                //         }
                //     }

                //     $url = "https://intasure-uk.acturis.com/AWE/Container.aspx?CurrentStep=QuoteRequestForm&ExternalPost=true&CurrentWorkflow=StandardB2C";

                //     if ($result['fpc_residence'] === 'eu') {
                //         $url = "https://intasure-eu.acturis.com/AWE/Container.aspx?CurrentStep=QuoteRequestForm&ExternalPost=true&CurrentWorkflow=StandardB2C";
                //     }

                //     $args = array(
                //         'method'    => 'POST',
                //         'body'      => json_encode($body),
                //         'headers'   => array(
                //             'Content-Type' => 'application/json'
                //         ),
                //     );

                //     $response = wp_remote_post($url, $args);

                //     if (is_wp_error($response)) {
                //         error_log($response->get_error_message());
                //         if(!$isProd) {
                //             $wpdb->delete(
                //                 $table_name,
                //                 array('id' => $result['id']),
                //                 array('%d')
                //             );
                //         }
                //     } else {
                //         error_log(wp_remote_retrieve_body($response));
                //         $wpdb->delete(
                //             $table_name,
                //             array('id' => $result['id']),
                //             array('%d')
                //         );
                //     }
                // }
                    
                // CREATE THE TABLE OF RESULTS FOR THE EMAIL
                $table = '<table border="1" cellpadding="5" cellspacing="0">';
                $table .= '<tr>';

                foreach (array_keys($results[0]) as $column_name) {
                    // REMOVE FPC_ PREFIX
                    if (str_starts_with($column_name, 'fpc_')) {
                        $column_name = substr($column_name, strlen('fpc_'));
                        $column_name = str_replace('_', ' ', $column_name);
                    }
                    
                    $column_name = ucfirst($column_name);
                    $table .= '<th>' . esc_html($column_name) . '</th>';
                }

                $table .= '</tr>';

                foreach ($results as $row) {
                    $table .= '<tr>';

                    foreach ($row as $column_value) {
                        $table .= '<td>' . esc_html($column_value) . '</td>';
                    }
                
                    $table .= '</tr>';
                }

                $table .= '</table>';
            }

            if (!$no_results) {
                $message = '<h2>Daily Partial Form Completion Report for ' . esc_html($today) . '</h2>';
                $message .= $table;
            } else {
                $message = '<h2>There are no partial form completion entries for ' . esc_html($today) . '</h2>';
            }

            // CONSTRUCT AND SEND THE EMAIL
            $to = $isProd ? 'leads@intasure.com,red@rcdata.co.uk' : 'dev@trunkbbi.com';
            $subject = 'Intasure Partial Form Completions';
            $headers = array('Content-Type: text/html; charset=UTF-8');
            
            $sent = wp_mail($to, $subject, $message, $headers);
            
            if ($sent) {
                error_log('Email sent successfully');

                foreach ($results as $result) {
                    $wpdb->delete(
                        $table_name,
                        array('id' => $result['id']),
                        array('%d')
                    );
                }
            } else {
                error_log('Failed to send email');
            }

            // SEND UTM DATA EMAIL
            $no_utm_data = empty($utm_data);

            if (!$no_utm_data) {
                $utm_table = '<table border="1" cellpadding="5" cellspacing="0">';
                $utm_table .= '<tr>';

                foreach (array_keys($utm_data[0]) as $column_name) {
                    if (str_starts_with($column_name, 'fpc_')) {
                        $column_name = substr($column_name, strlen('fpc_'));
                        $column_name = str_replace('_', ' ', $column_name);
                    }
                    
                    $column_name = ucfirst($column_name);
                    $utm_table .= '<th>' . esc_html($column_name) . '</th>';
                }

                $utm_table .= '</tr>';

                foreach ($utm_data as $row) {
                    $utm_table .= '<tr>';

                    foreach ($row as $column_value) {
                        $utm_table .= '<td>' . esc_html($column_value) . '</td>';
                    }
                
                    $utm_table .= '</tr>';
                }

                $utm_table .= '</table>';
            }

            if (!$no_utm_data) {
                $utm_message = '<h2>Intasure UTM Form Data for ' . esc_html($today) . '</h2>';
                $utm_message .= $utm_table;
            } else {
                $utm_message = '<h2>There is no UTM data for form entries for ' . esc_html($today) . '</h2>';
            }

            $utm_to = 'dev@trunkbbi.com,craig.murphy@trunkbbi.com,jon.butler@trunkbbi.com';
            $utm_subject = 'Intasure UTM Form Data';
            $utm_headers = array('Content-Type: text/html; charset=UTF-8');
            
            $utm_sent = wp_mail($utm_to, $utm_subject, $utm_message, $utm_headers);
            
            if ($utm_sent) {
                error_log('Email sent successfully');
            } else {
                error_log('Failed to send email');
            }
        }

        function clearScheduledEvents()
        {
            $next_daily_event_timestamp = wp_next_scheduled('form_partial_completion_event');
            
            if ($next_daily_event_timestamp) {
                wp_unschedule_event($next_daily_event_timestamp, 'form_partial_completion_event' );
            }
        }

        function getIntroducerName($introducer_id) {
            $args = array(
                'post_type' => 'introducers',
                'meta_query' => array(
                    'relation' => 'OR',
                    array(
                        'key' => 'ampology_default_introducer',
                        'value' => $introducer_id,
                        'compare' => '='
                    ),
                    array(
                        'key' => 'ampology_acturis_uk',
                        'value' => $introducer_id,
                        'compare' => '='
                    ),
                    array(
                        'key' => 'ampology_acturis_eu',
                        'value' => $introducer_id,
                        'compare' => '='
                    )
                ),
                'posts_per_page' => 1
            );
        
            $query = new WP_Query($args);
        
            if ($query->have_posts()) {
                $query->the_post();
                return html_entity_decode(get_the_title());
            }
        
            return 'Unknown Introducer';
        }
    }

    new TrunkBBI();
}
